package com.digiwin.athena.abt.application.service.atmc.migration.backlog;

import com.digiwin.athena.abt.application.dto.migration.atmc.bpm.BpmTaskApprovePreviousActivityDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.bpm.BpmTaskPreApproveRequestDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.bpm.BpmWorkitemAppendixService;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogTransformService;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BusinessKeyService;
import com.digiwin.athena.abt.application.service.atmc.migration.bpm.TaskEngineService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.constants.ApiExecuteErrorConstant;
import com.digiwin.athena.abt.core.meta.constants.BpmConstant;
import com.digiwin.athena.abt.core.meta.constants.GlobalConstant;
import com.digiwin.athena.abt.core.meta.enums.*;
import com.digiwin.athena.abt.core.uiils.PatternCategoryUtil;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.*;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.ActivityDataBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmWorkItemRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityStep;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmWorkitemAppendix;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class BpmBacklogActionCreateService extends BacklogActionCreateParentService {


    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    private BacklogMapper backlogMapper;

    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;

    @Autowired
    private BusinessKeyService businessKeyService;

    @Autowired
    private BpmActivityMapper bpmActivityMapper;

    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    @Autowired
    private PtmBacklogTransformService ptmBacklogTransformService;

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private BpmActivityStepMapper bpmActivityStepMapper;

    @Autowired
    private BpmWorkitemAppendixService bpmWorkitemAppendixService;

    @Autowired
    private TaskEngineService taskEngineService;

    public Map<String, Object> getEditActions(AuthoredUser authoredUser, long workitemId, Boolean isHistory) {
        return getEditActions(authoredUser, workitemId, isHistory, null);
    }

    /**
     * @param workitemId
     * @return
     */
    public Map<String, Object> getEditActions(AuthoredUser authoredUser, long workitemId, Boolean isHistory, PtmWorkItemRecordBO ptmWorkItemRecordBO) {

        ActivityDataBO backLogMap = null;
        //perf：基于目前大部分数据是任务引擎，优先查询ptm数据，减少一次数据库查询连接和耗时 start
        Boolean isPtm = true;
        List<ActivityDataBO> list = commonPtmTransformService.getActivityDataByBacklogId(workitemId,null, isHistory, ptmWorkItemRecordBO);
        if (CollectionUtils.isEmpty(list)) {
            list = backlogMapper.getActivityDatasByBacklogId(workitemId);
            isPtm = false;
        }
        //perf：基于目前大部分数据是任务引擎，优先查询ptm数据，减少一次数据库查询连接和耗时 end

        //如果是数据一致性的异常排除任务卡则查询其原任务卡的数据
        BpmActivityWorkitem abnormalWorkitem = null;
        if (!isPtm) {
            abnormalWorkitem = bpmActivityWorkitemMapper.selectById(workitemId);
            if (abnormalWorkitem != null && abnormalWorkitem.getType() == 89) {
                list = backlogMapper.getActivityDatasByBacklogId(abnormalWorkitem.getSourceWorkitemId());
            }
        }

        if (list.size() > 1) {
            if (!isPtm) {
                Optional<ActivityDataBO> mainWorkItem = list.stream().filter(item -> item.getGroupId() == null || item.getGroupId() == 0L).findFirst();
                if (mainWorkItem.isPresent()) {
                    backLogMap = mainWorkItem.get();
                }
                list = list.stream().filter(item -> item.getGroupId() != null && item.getGroupId() > 0L).collect(Collectors.toList());
            } else {
                backLogMap = list.get(0);
            }
        } else if (list.size() == 1) {
            backLogMap = list.get(0);
        }


        if (null == backLogMap) {
            // 查询API执行异常任务卡信息
            backLogMap = backlogMapper.getInternalErrorActivityDataByBacklogId(workitemId);
            if (backLogMap != null) {
                isPtm = false;
                // 设置tmPattern、tmCategory
                backLogMap.setTmPattern(ApiExecuteErrorConstant.TM_PATTERN);
                backLogMap.setTmCategory(ApiExecuteErrorConstant.TM_CATEGORY);
                backLogMap.setTmShowFlow(Boolean.FALSE);
                backLogMap.setProcessCreateTime(backLogMap.getTaskStartTime());

                backLogMap.setTmTaskId(ApiExecuteErrorConstant.TM_TASK_ID);
                backLogMap.setTmActivityId(ApiExecuteErrorConstant.TM_ACTIVITY_ID);
            }
        }

        if (backLogMap == null) {
            throw AtmcErrorCodeEnum.ACTIVITY_CAN_NOT_FIND.getBusinessExceptionWithArgs(workitemId);
        }

        if (backLogMap.getOverdueWorkitemId() != null && backLogMap.getOverdueWorkitemId() > 0) {
            backLogMap.setTmTaskId(ApiExecuteErrorConstant.TM_TASK_ID);
            backLogMap.setTmActivityId(GlobalConstant.OVERDUE_WORKITEM_ACTIVITY_CODE);
            backLogMap.setTmPattern(GlobalConstant.OVERDUE_WORKITEM_PATTER);
            backLogMap.setTmCategory(GlobalConstant.OVERDUE_WORKITEM_CATEGORY);
            backLogMap.setTmShowFlow(false);

            if (!Objects.equals(backLogMap.getDataFrom(), BpmConstant.DATA_FROM_PTM)) {
                Backlog originalBacklog = backlogMapper.selectFirstByActivityStepId(backLogMap.getStepId());
                backLogMap.setPerformerId(originalBacklog.getPerformerId());
                backLogMap.setPerformerName(originalBacklog.getPerformerName());
                backLogMap.setPlanEndTime(originalBacklog.getEndTime());
            }
            backLogMap.setTmActivityName(GlobalConstant.OVERDUE_BACKLOG_NAME);
            backLogMap.setBacklogName(GlobalConstant.OVERDUE_BACKLOG_NAME);
            //逾时任务卡永远不用代理token
            backLogMap.setProxyToken(null);
        }
        //数据一致性异常卡类型
        if (abnormalWorkitem != null) {
            backLogMap.setType(abnormalWorkitem.getType());
        }

        for (ActivityDataBO activityDataBO : list) {
            if (!isPtm) {
                BpmActivityWorkitem workItem = BpmActivityWorkitem.builder()
                        .id(activityDataBO.getWorkItemId())
                        .activityStepId(activityDataBO.getStepId())
                        .performerId(activityDataBO.getPerformerId())
                        .performerName(activityDataBO.getPerformerName())
                        .workitemId(activityDataBO.getBpmWorkItemId())
                        .sourceWorkitemId(activityDataBO.getSourceWorkitemId())
                        .createType(activityDataBO.getCreateType())
                        .state(activityDataBO.getState())
                        .subState(activityDataBO.getSubState())
                        .agentPerformerId(activityDataBO.getAgentPerformerId())
                        .agentPerformerName(activityDataBO.getAgentPerformerName())
                        .comment(activityDataBO.getComment())
                        .performerType(activityDataBO.getPerformerType())
                        .overdueWorkitemId(activityDataBO.getOverdueWorkitemId())
                        .type(activityDataBO.getType())
                        .createType(activityDataBO.getCreateType())
                        .groupId(activityDataBO.getGroupId())
                        .build();
                if (activityDataBO != null) {
                    if (Objects.equals(activityDataBO.getType(), GlobalConstant.ASSIST_TYPE)) {
                        //辅助执行者，查找真正的执行人信息
                        List<BpmActivityWorkitem> workitemList = bpmActivityWorkitemMapper.selectNormalByStepSqlId(workItem.getActivityStepId());
                        if (CollectionUtils.isEmpty(workitemList)) {
                            activityDataBO.setWorkitemList("[" + JsonUtils.objectToString(workItem) + "]");
                        } else {
                            activityDataBO.setWorkitemList("[" + JsonUtils.objectToString(workitemList.get(0)) + "]");
                        }
                    } else {
                        activityDataBO.setWorkitemList("[" + JsonUtils.objectToString(workItem) + "]");
                    }
                } else {
                    activityDataBO.setWorkitemList(null);
                }
            }
            if (backLogMap.getType() == 89) {
                activityDataBO.setBacklogName(GlobalConstant.DATA_UNIFORMITY_BACKLOG_NAME);
                activityDataBO.setPlanEndTime(null);
            }
        }


        Map<String, Object> map = getActions(list, "", isPtm);
        map.put(BpmConstant.DATA_FROM_NAME, backLogMap.getDataFrom());


        processSolve(workitemId, backLogMap, map);
        processApproval(workitemId, backLogMap, map);
        processReplyInvite(workitemId, backLogMap.getTmCategory(), map);
        processApprove(backLogMap, map);

        //添加退回重签信息
        BpmActivityWorkitem workitem = bpmActivityWorkitemMapper.selectReapprovalInfoById(workitemId);
        if (workitem == null) {
            workitem = commonPtmTransformService.getReapprovalInfoById(workitemId);
        }
        map.put("reapprovalInfo", workitem);

        /*获取异动数据 start*/
        List<Long> workitemIdList = list.stream().map(ActivityDataBO::getWorkItemId).collect(Collectors.toList());
        List<Map> differentDataList = businessKeyService.queryDifferentDataByWorkitemId(authoredUser.getTenantId(), workitemIdList);
        List<BpmActivityWorkitem> dataUniformifyTask = businessKeyService.queryDataUniformifyTasks(workitemId);
        map.put("abnormalData", differentDataList);
        //异动数据主卡链接异动数据卡
        map.put("abnormalCards", dataUniformifyTask);
        /*获取异动数据 end*/
        map.put("type", backLogMap.getType());
        map.put("abnormalWorkitemId", workitemId);
        //获取唯一提交标识
        map.put("submitId",this.getSubmitId(workitemId));
        return map;
    }

    private Map<String, Object> getActions(List<ActivityDataBO> list, String engineType, boolean isPtm) {

        if (CollectionUtils.isEmpty(list) || list.get(0) == null) {
            return null;
        }
        //todo:效率优化，暂时去掉，有问题找陈旭松
        //添加前置任务信息
//        for (ActivityDataDTO activityDataDTO : list) {
//            //如果有前置任务，则获取前置任务信息
//            if (StringUtils.hasText(activityDataDTO.getPreTaskUid())) {
//                BpmActivityWorkitem bpmActivityWorkitem = bpmActivityWorkitemMapper.selectLastSubmitWorkItem(activityDataDTO.getPreTaskUid());
//                if (bpmActivityWorkitem != null) {
//                    activityDataDTO.setPrePerformerId(bpmActivityWorkitem.getPerformerId());
//                    activityDataDTO.setPrePerformerName(bpmActivityWorkitem.getPerformerName());
//                    activityDataDTO.setPreAgentPerformerId(bpmActivityWorkitem.getAgentPerformerId());
//                    activityDataDTO.setPreAgentPerformerName(bpmActivityWorkitem.getAgentPerformerName());
//                    activityDataDTO.setPrePerformerType(bpmActivityWorkitem.getPerformerType());
//                }
//            }
//        }
        Map<String, Object> root = new HashMap<>();

        ActivityDataBO activityDataBO = list.get(0);
        Map<String, Object> project = new HashMap<>();
        root.put("project", project);
        project.put("projectId", activityDataBO.getTaskId());
        project.put("tmProjectId", activityDataBO.getTmTaskId());
        project.put("chargeId", activityDataBO.getChargeId());
        project.put("chargeName", activityDataBO.getChargeName());
        project.put("tenantId", activityDataBO.getTenantId());
        project.put("startTime", activityDataBO.getTaskStartTime());
        project.put("endTime", activityDataBO.getTaskEndTime());
        project.put("projectName", activityDataBO.getTaskName());
        project.put("processCreateTime", activityDataBO.getProcessCreateTime());
        project.put("projectBpmData", activityDataBO.getProjectBpmData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getProjectBpmData(), Map.class));

        if (!StringUtils.isEmpty(activityDataBO.getTaskSourceIds())) {
            List<String> ids = new ArrayList<>();
            for (String item : activityDataBO.getTaskSourceIds().split(",")) {
                ids.add(item);
            }
            project.put("sourceIds", ids);
        }

        List<String> processSerialNumberList = new ArrayList<>();
        for (ActivityDataBO dataDTO : list) {
            String key = dataDTO.getProcessSerialNumber() + dataDTO.getTaskUid();
            if (!processSerialNumberList.contains(key)) {
                processSerialNumberList.add(key);
            }
        }


        List<Map<String, Object>> tasks = new ArrayList<>();
        root.put("tasks", tasks);
        for (String processSerialNumber : processSerialNumberList) {
            List<ActivityDataBO> activities = list.stream().filter(x -> (x.getProcessSerialNumber() + x.getTaskUid()).equals(processSerialNumber))
                    .collect(Collectors.toList());

            //降序排列，取最新的
            Collections.sort(activities, (o1, o2) -> {
                if (o1.getBacklogId() != null && o2.getBacklogId() != null) {
                    return o2.getBacklogId().compareTo(o1.getBacklogId());
                } else {
                    return o2.getBpmActivitySqlId().compareTo(o1.getBpmActivitySqlId());
                }
            });
            Optional<ActivityDataBO> activityOpt = activities.stream().findFirst();
            if (activityOpt.isPresent()) {
                activityDataBO = activityOpt.get();
            }

            Map<String, Object> taskObject = new HashMap<>();
            tasks.add(taskObject);

            taskObject.put("processSerialNumber", activityDataBO.getProcessSerialNumber());
            taskObject.put("bpmActivitySqlId", activityDataBO.getBpmActivitySqlId());
            taskObject.put("bpmData", activityDataBO.getBpmData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBpmData(), Map.class));
            taskObject.put("stateData", activityDataBO.getBpmStateData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBpmStateData(), Map.class));
            taskObject.put("tmActivityId", activityDataBO.getTmActivityId());
            taskObject.put("compositionId", activityDataBO.getCompositionId());
            taskObject.put("tmCategory", activityDataBO.getTmCategory());
            taskObject.put("tmPattern", activityDataBO.getTmPattern());
            taskObject.put("bpmActivityId", activityDataBO.getBpmActivityId());
            taskObject.put("bpmActivityType", activityDataBO.getBpmActivityType());
            taskObject.put("performerIds", activityDataBO.getPerformerIds() == null ? null : JsonUtils.jsonToObject(activityDataBO.getPerformerIds(), new ArrayList<String>().getClass()));
            taskObject.put("businessUnit", activityDataBO.getBusinessUnit() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBusinessUnit(), Map.class));
            taskObject.put("tmActivityName", activityDataBO.getTmActivityName());
            taskObject.put("proxyToken", activityDataBO.getProxyToken());
            taskObject.put("traceId", activityDataBO.getTraceId());
            taskObject.put("type", activityDataBO.getType());
            taskObject.put("taskUid", activityDataBO.getTaskUid());

            //增加营运单元信息
            List<String> eocNames = new ArrayList();
            if (!StringUtils.isEmpty(activityDataBO.getEocName()) && !eocNames.contains(activityDataBO.getEocName())) {
                eocNames.add(activityDataBO.getEocName());
            }
            taskObject.put("eocName", eocNames);

            if (!StringUtils.isEmpty(activityDataBO.getApprovalState())) {
                taskObject.put("approvalState", GlobalConstant.backlogStatusMap.getOrDefault(activityDataBO.getApprovalState(), ""));
                taskObject.put("isRapprovalInfoShow", activityDataBO.getApprovalState());
            }

            //backlog
            List<Map<String, Object>> backlogs = new ArrayList<>();
            taskObject.put("backlog", backlogs);

            for (ActivityDataBO dataDTO : activities) {
                if (dataDTO.getBacklogId() == null) {
                    continue;
                }

                Integer submitId = ptmBacklogMapper.selectSubIdBatByBackId(dataDTO.getPtmBacklogId());

                Map<String, Object> backlog = new HashMap<>();
                backlogs.add(backlog);

                backlog.put("backlogId", dataDTO.getWorkItemId());
                // 执行者的租户id
                backlog.put("targetTenantId", dataDTO.getTargetTenantId());
                backlog.put("performerId", dataDTO.getPerformerId());
                backlog.put("performerName", dataDTO.getPerformerName());
                backlog.put("performerAgentId", dataDTO.getPerformerAgentId());
                backlog.put("performerAgentName", dataDTO.getPerformerAgentName());
                backlog.put("performerState", dataDTO.getPerformerState());
                backlog.put("readCount", dataDTO.getReadCount());
                backlog.put("startTime", dataDTO.getStartTime());
                backlog.put("planEndTime", dataDTO.getPlanEndTime());
                backlog.put("endTime", dataDTO.getEndTime());
                backlog.put("closed", dataDTO.getBacklogClosed());
                backlog.put("backlogName", dataDTO.getBacklogName());
                backlog.put("ptmBacklogId", dataDTO.getPtmBacklogId());
                backlog.put("submitId", submitId);
                backlog.put("ptmWorkItemId", dataDTO.getPtmWorkItemId());
                backlog.put("merge", dataDTO.getMerge());
                backlog.put("planEndTimeMin", dataDTO.getPlanEndTimeMin());
                backlog.put("planEndTimeMax", dataDTO.getPlanEndTimeMax());
                backlog.put("createType", dataDTO.getCreateType());

                //增加营运单元信息
                if (!StringUtils.isEmpty(dataDTO.getEocName()) && !eocNames.contains(dataDTO.getEocName())) {
                    eocNames.add(dataDTO.getEocName());
                }

                //如果有前置任务，则获取前置任务信息
                //chenxsa 效率优化去掉
//                if (StringUtils.hasText(dataDTO.getPreTaskUid())){
//                    BpmActivityWorkitem preWorkItem = bpmActivityWorkitemMapper.selectLastSubmitWorkItem(dataDTO.getPreTaskUid());
//                    if (preWorkItem != null){
//                        backlog.put("prePerformerId", dataDTO.getPrePerformerId());
//                        backlog.put("prePerformerName", dataDTO.getPrePerformerName());
//                        backlog.put("preAgentPerformerId", dataDTO.getPreAgentPerformerId());
//                        backlog.put("preAgentPerformerName", dataDTO.getPreAgentPerformerName());
//                        backlog.put("prePerformerType", dataDTO.getPrePerformerType());
//                    }
//                }

                if (dataDTO.getEndTime() == null) {
                    if (dataDTO.getMerge() && isPtm) {
                        //倒计时
                        backlog.put("remainTime", TimeUtils.dateInterval(LocalDateTime.now(), dataDTO.getPlanEndTimeMin()));
                        //逾期
                        backlog.put("overdueDate", TimeUtils.dateInterval(dataDTO.getPlanEndTimeMin(), LocalDateTime.now()));
                    } else {
                        //倒计时
                        backlog.put("remainTime", TimeUtils.dateInterval(LocalDateTime.now(), dataDTO.getPlanEndTime()));
                        //逾期
                        backlog.put("overdueDate", TimeUtils.dateInterval(dataDTO.getPlanEndTime(), LocalDateTime.now()));
                    }
                }
                backlog.put("workitemList", dataDTO.getWorkitemList() == null ? null : JsonUtils.jsonToObject(dataDTO.getWorkitemList(), tasks.getClass()));
                //如果有就返回，不判断是否完成
                backlog.put("finishedActionId", dataDTO.getFinishedActionId());
                if (StringUtils.isEmpty(dataDTO.getFinishedActionId()) && Objects.equals(3, dataDTO.getStepState())) {
                    //如果没有结束按钮，且已结束，特殊处理终止、撤销等状态
                    if (Objects.equals(ActivityWorkitemSubState.END_TASK_UNDO.getValue(), dataDTO.getStepSubState())) {
                        //已撤销
                        backlog.put("finishedActionId", "athena_bpm_cancel");
                    } else {
                        //其他情况，赋值已结束
                        backlog.put("finishedActionId", "uibot_action_id_finished");
                    }
                }
                backlog.put("bpmSignReason", dataDTO.getStepSignReason());

                //暂时只取一个，后期支持会签和或签的时候，还需要处理
                if (!Objects.equals(engineType, BpmEngineCategoryEnum.TaskEngine.getCategory())) {
                    break;
                }
            }
        }
        return root;
    }

    private void processSolve(long workitemId, ActivityDataBO backLogMap, Map<String, Object> map) {
        if (Objects.equals(TmTaskPatternEnum.BUSINESS.getValue(), backLogMap.getTmPattern())
                && Objects.equals(TmTaskCategoryEnum.SOLVE.getValue(), backLogMap.getTmCategory())) {
            //异常排除的，检查是否可以撤回
            JSONArray jsonArray = new JSONArray();
            Map<String, List<String>> startApproveMap = new HashMap<>();
            List<Map> actList = bpmActivityMapper.selectNoFinishedListByOriginBacklogId(workitemId);
            if (CollectionUtils.isEmpty(actList)) {
                actList = ptmBacklogTransformService.selectNoFinishedListByOriginBacklogIdForSolve(workitemId);
            }
            for (Map m : actList) {
                JSONObject dataJson = JSONObject.fromObject(m.get("data"));
                if (!dataJson.containsKey("originalQueryVariableName")) {
                    continue;
                }
                String detailField = null;
                if (dataJson.containsKey("detailField") && dataJson.get("detailField") != null) {
                    detailField = dataJson.getString("detailField");
                }
                String tmTaskId = m.get("tm_task_id").toString();
                String tmActivityId = m.get("tm_activity_id").toString();
                List<String> startApproveIdList = null;
                if (startApproveMap.containsKey(tmActivityId)) {
                    //任务id相同，定义相同
                    startApproveIdList = startApproveMap.get(tmActivityId);
                } else {
                    startApproveIdList = getStartApproveActivity(tmTaskId, tmActivityId);
                    startApproveMap.put(tmActivityId, startApproveIdList);
                }

                if (!CollectionUtils.isEmpty(startApproveIdList) && startApproveIdList.contains(backLogMap.getTmActivityId())) {
                    //能撤回,如果是审核关卡，且审核关卡的发起任务ID是当前任务，能撤回
                    Map<String, Object> terminateMap = new HashMap<>();
                    if (m.containsKey(BpmConstant.DATA_FROM_NAME) && Objects.equals(m.get(BpmConstant.DATA_FROM_NAME), BpmConstant.DATA_FROM_PTM)) {
                        terminateMap.put("serialNumber", m.get("processSerialNumber"));
                        terminateMap.put("performerId", m.get("personInCharge"));
                        terminateMap.put("performerType", 0);
                        terminateMap.put("comment", "");
                    } else {
                        BpmActivityStep activityStep = bpmActivityStepMapper.selectNoCompletedByBpmActivitySqlId(Long.valueOf(m.get("bpmActivitySqlId").toString()));
                        JSONObject workItem = (JSONObject) activityStep.getWorkitemList().getJSONObject(0);
                        terminateMap.put("processSerialNumber", m.get("process_serial_number"));
                        terminateMap.put("performerId", workItem.get("performerId"));
                        terminateMap.put("workitemId", workItem.get("workitemId"));
                        terminateMap.put("comment", "");
                        terminateMap.put("locale", LocaleContextHolder.getLocale().toString());
                    }
                    JSONArray dataKeys = dataJson.getJSONArray(dataJson.getString("originalQueryVariableName"));
                    List<JSONObject> detailAllDataKeys = getDetailAllDataKeys(dataKeys, detailField);
                    for (int i = 0; i < dataKeys.size(); i++) {
                        JSONObject dkJson = dataKeys.getJSONObject(i);
                        if (detailField != null && dkJson.containsKey(detailField)) {
                            JSONArray subKeys = dkJson.getJSONArray(detailField);
                            for (Object o : subKeys) {
                                JSONObject kv = new JSONObject();
                                kv.put("dataKey", o);
                                kv.put("processParameter", terminateMap);
                                kv.put("allKey", detailAllDataKeys);
                                jsonArray.add(kv);
                            }
                        } else {
                            JSONObject kv = new JSONObject();
                            kv.put("dataKey", dkJson);
                            kv.put("processParameter", terminateMap);
                            kv.put("allKey", dataKeys);
                            jsonArray.add(kv);
                        }
                    }
                }
            }

            if (!CollectionUtils.isEmpty(jsonArray)) {
                List tasks = (List) map.get("tasks");
                if (!CollectionUtils.isEmpty(tasks)) {
                    tasks.forEach(task -> {
                        Map taskMap = (Map) task;
                        taskMap.put("abortDataKeys", jsonArray);
                    });
                }
            }
        }
    }

    /**
     * 回复型任务注册邀请
     *
     * @param workitemId
     * @param tmCategory
     * @param map
     */
    private void processReplyInvite(long workitemId, String tmCategory, Map<String, Object> map) {
        if (Objects.equals(tmCategory, TmTaskCategoryEnum.REPLY.getValue())) {
            BpmWorkitemAppendix appendix = bpmWorkitemAppendixService.getByBacklogId(workitemId);
            if (appendix != null && !Objects.equals(appendix.getErrorCode(), WorkitemAppendixType.ReSend.getValue())) {
                Map appendixMap = new HashMap();
                appendixMap.put("backlogId", appendix.getId());
                appendixMap.put("errorCode", appendix.getErrorCode());
                appendixMap.put("email", appendix.getEmail());
                appendixMap.put("supplierName", appendix.getSupplierName());

                List tasks = (List) map.get("tasks");
                if (!CollectionUtils.isEmpty(tasks)) {
                    Map task = (Map) tasks.get(0);
                    task.put("replyInvite", appendixMap);
                }
            }
        }
    }

    /**
     * 获取签核信息
     *
     * @param backLogMap
     * @param map
     */
    private void processApprove(ActivityDataBO backLogMap, Map<String, Object> map) {
        if (backLogMap == null || StringUtils.isEmpty(backLogMap.getWorkitemList())
                || !PatternCategoryUtil.isApproval(backLogMap.getTmCategory())) {
            return;
        }

        //只处理签核
        JSONArray jsonArray = JSONArray.fromObject(backLogMap.getWorkitemList());
        String workItemId = jsonArray.getJSONObject(0).getString("workitemId");
        if (StringUtils.isEmpty(workItemId)) {
            return;
        }
        //只处理任务引擎
        if (!Objects.equals(BpmConstant.DATA_FROM_PTM, backLogMap.getDataFrom())) {
            return;
        }
        //是否已签核
        if (CollectionUtils.isEmpty(this.getPreApproveList(workItemId).getActivities())) {
            return;
        }
        map.put("hasApprove", true);
    }

    /**
     * 获取提交唯一键
     * @param workItemId
     * @return
     */
    private Integer getSubmitId(Long workItemId) {
        Integer submitId = null;
        if (workItemId != null) {
            submitId = ptmBacklogMapper.selectSubIdBatByBackId(workItemId);
        }
        return submitId;
    }

    private List<String> getStartApproveActivity(String tmTaskId, String tmActivityId) {

        TmActivityResponseDTO resonse = themeMapService.getActivityAction(tmTaskId, tmActivityId, TmPageName.TASK_CARD_NAME.getValue());
        return resonse.getStartApproveActivity();
    }

    private List<JSONObject> getDetailAllDataKeys(JSONArray dataKeys, String detailField) {
        List<JSONObject> result = new ArrayList<>();

        for (int i = 0; i < dataKeys.size(); i++) {
            JSONObject dkJson = dataKeys.getJSONObject(i);
            if (detailField != null && dkJson.containsKey(detailField)) {
                result.addAll(dkJson.getJSONArray(detailField));
            }
        }

        return result;
    }

    private BpmTaskApprovePreviousActivityDTO getPreApproveList(String workItemId) {
        BpmTaskPreApproveRequestDTO requestDTO = BpmTaskPreApproveRequestDTO.builder()
                .locale(LocaleContextHolder.getLocale().toLanguageTag())
                .workitemId(workItemId)
                .build();
        return taskEngineService.queryPreApprove(requestDTO);
    }
}
