package com.digiwin.athena.abt.application.service.atmc.migration.backlog;

import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.ReplyTaskMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.*;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.bpm.BpmWorkitemAppendixService;
import com.digiwin.athena.abt.application.service.atmc.migration.commontype.CardPresentConfigQryService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.AglieService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.ActivityUtils;
import com.digiwin.athena.abt.application.utils.ManualTaskUtil;
import com.digiwin.athena.abt.core.meta.constants.ApiExecuteErrorConstant;
import com.digiwin.athena.abt.core.meta.constants.BpmConstant;
import com.digiwin.athena.abt.core.meta.constants.GlobalConstant;
import com.digiwin.athena.abt.core.meta.constants.ManualTaskConstant;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.core.meta.enums.TmTaskCategoryEnum;
import com.digiwin.athena.abt.core.meta.enums.TmTaskPatternEnum;
import com.digiwin.athena.abt.core.meta.enums.WorkitemAppendixType;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BpmActivityMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BpmActivityWorkitemMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.BacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivity;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.*;

/**
 * 任务卡的摘要服务(新)
 */
@Slf4j
@Service
public class BpmCommonBacklogAbstractService {


    @Autowired
    private BacklogMapper backlogMapper;

    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    private MessageUtils messageUtils;

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;

    @Autowired
    private CardPresentConfigQryService cardPresentConfigQryService;

    @Autowired
    private BpmBacklogActionCreateService bpmBacklogActionCreateService;

    @Autowired
    private AglieService aglieService;

    @Autowired
    private BpmWorkitemAppendixService bpmWorkitemAppendixService;

    @Autowired
    private BpmActivityMapper bpmActivityMapper;

    @Autowired
    private UserService userService;


    private static final String BACKLOG_OVERDUE_TASK_MSG = "backlog.overdue.task.msg";

    private static final String SUMMARY_LAYOUT_STR = "summaryLayoutStr";

    /**
     * 获取任务卡摘要拼接信息
     *
     * @param workItemId
     * @param user
     * @return
     */
//    @MockData(type = "detail")
    public Map getBacklogCardAbstractById(long workItemId, AuthoredUser user, boolean needHistoryInfo) {
        BacklogBO backlogBO = backlogMapper.selectBacklogForCard(workItemId);
        if (null == backlogBO) {
            backlogBO = commonPtmTransformService.selectBacklogForCard(workItemId);
            backlogBO.setDataFrom(BpmConstant.DATA_FROM_PTM);
        }

        // 应用行事历任务支持查询概要信息
        if (ManualTaskConstant.VIRTUAL_PROJECT.equals(backlogBO.getTmTaskId())) {
            // 流程变量
            String bpmData = backlogBO.getBpmData();
            if (StringUtils.isEmpty(bpmData)) {
                return Collections.emptyMap();
            }
            JSONObject bpmDataObj = JSONObject.fromObject(bpmData);

            /* 判断是不是应用行事历 start */
            // taskCode是否有值
            boolean hasTaskCode = bpmDataObj.containsKey(ManualTaskConstant.BpmDataKey.TASK_CODE)
                    && !StringUtils.isEmpty(bpmDataObj.getString(ManualTaskConstant.BpmDataKey.TASK_CODE));
            // tmActivityId是否有值
            boolean hasTmActivityId = bpmDataObj.containsKey(ManualTaskConstant.BpmDataKey.TM_ACTIVITY_ID)
                    && !StringUtils.isEmpty(bpmDataObj.getString(ManualTaskConstant.BpmDataKey.TM_ACTIVITY_ID));
            // 若taskCode和tmActivityId都不存在则不是应用行事历任务
            if (!hasTaskCode && !hasTmActivityId) {
                return Collections.emptyMap();
            }
            /* 判断是不是应用行事历 end */

            // 获取行事历的code
            String tmActivityId = StringUtils.isEmpty(bpmDataObj.getString(ManualTaskConstant.BpmDataKey.TASK_CODE))
                    ? bpmDataObj.getString(ManualTaskConstant.BpmDataKey.TM_ACTIVITY_ID)
                    : bpmDataObj.getString(ManualTaskConstant.BpmDataKey.TASK_CODE);
            // 若code等于uibotManualTask则不是应用行事历
            if (ManualTaskConstant.MANUAL_TASK_ID.equals(tmActivityId)) {
                return Collections.emptyMap();
            }
            backlogBO.setCalendar(true);
            backlogBO.setTmActivityId(tmActivityId);
        }

        Map<String, Object> checkItems_map = new HashMap<>();
        if (backlogBO.getOverdueWorkitemId() != null && backlogBO.getOverdueWorkitemId() > 0) {
            backlogBO.setName(GlobalConstant.OVERDUE_BACKLOG_NAME);
            backlogBO.setTmTaskId(ApiExecuteErrorConstant.TM_TASK_ID);
            backlogBO.setTmActivityId(GlobalConstant.OVERDUE_WORKITEM_ACTIVITY_CODE);
            backlogBO.setTmPattern(GlobalConstant.OVERDUE_WORKITEM_PATTER);
            backlogBO.setTmCategory(GlobalConstant.OVERDUE_WORKITEM_CATEGORY);

            Backlog originalBacklog = getOriginalBacklog(backlogBO.getOverdueWorkitemId());
            List<Map<String, Object>> checkItems = new ArrayList<>();
            backlogBO.setCheckItems(checkItems);
            checkItems_map.put("item",
                    messageUtils.getMessageWithFormat(BACKLOG_OVERDUE_TASK_MSG,
                            MessageUtils.getMessageByCurrentLanguage(originalBacklog.getName()),
                            TimeUtils.dateInterval(originalBacklog.getEndTime(), LocalDateTime.now())));
            checkItems.add(checkItems_map);
            backlogBO
                    .setOperation(MessageUtils.getMessageByCurrentLanguage(GlobalConstant.OVERDUE_WORKITEM_OPERATION));
        }
        // 数据一致性异常排除任务卡
        if (GlobalConstant.DATA_UNIFORMITY_BACKLOG_TYPE.equals(backlogBO.getType())) {
            backlogBO.setName(GlobalConstant.DATA_UNIFORMITY_BACKLOG_NAME);
        }
        setCheckItems(user, backlogBO);
        Map<String, Object> summaryLayoutStr = setSummaryLayoutStr(user, backlogBO, needHistoryInfo);
        String reapprovalInfoComment = "";
        // 退回意见，只要退回都显示，若以后重新发起不要显示，把if代码放开即可(排除异常任务)
        boolean isAbnormal = org.springframework.util.StringUtils.pathEquals(TmTaskPatternEnum.BUSINESS.getValue(),
                backlogBO.getTmPattern())
                && org.springframework.util.StringUtils.pathEquals(TmTaskCategoryEnum.SOLVE.getValue(),
                backlogBO.getTmCategory());
        String targetApproveActivity = themeMapService.getActivityTargetCode(backlogBO.getTmTaskId(),
                backlogBO.getTmActivityId(), TmPageName.TASK_CARD_NAME.getValue());
        boolean isApproval = Objects.equals(backlogBO.getTmPattern(), TmTaskPatternEnum.BUSINESS.getValue())
                && Objects.equals(backlogBO.getTmCategory(), TmTaskCategoryEnum.APPROVAL.getValue());

        // 非异常任务可取退回意见
        if (!isAbnormal) {
            if (!StringUtils.isEmpty(targetApproveActivity) || isApproval) {
                // 根据workItemId获取退回重签意见
                BpmActivityWorkitem bpmWorkitem = bpmActivityWorkitemMapper.selectReapprovalInfoById(workItemId);
                if (bpmWorkitem != null) {
                    reapprovalInfoComment = messageUtils.getMessage("reapproval.info.comment")
                            + bpmWorkitem.getComment();
                }
                else {
                    // PTM
                    String comment = commonPtmTransformService.getExecuteComment(workItemId);
                    if (!StringUtils.isEmpty(comment)) {
                        reapprovalInfoComment = messageUtils.getMessage("reapproval.info.comment") + comment;
                    }
                }
            }
        }
        Map<String, Object> checkItemsMap = new HashMap<>();
        if (summaryLayoutStr != null) {
            if (summaryLayoutStr.containsKey(SUMMARY_LAYOUT_STR)
                    && !StringUtils.isEmpty(summaryLayoutStr.get(SUMMARY_LAYOUT_STR).toString())) {
                if (!StringUtils.isEmpty(reapprovalInfoComment)) {
                    String summaryLayout = reapprovalInfoComment + "<br>"
                            + summaryLayoutStr.get(SUMMARY_LAYOUT_STR).toString();
                    summaryLayoutStr.put(SUMMARY_LAYOUT_STR, summaryLayout);
                }
            }
            else {
                summaryLayoutStr.put(SUMMARY_LAYOUT_STR, reapprovalInfoComment);
            }
            checkItemsMap.put("summaryLayout", summaryLayoutStr.get(SUMMARY_LAYOUT_STR));
            checkItemsMap.put("historyMessage", summaryLayoutStr.get("historyMessage"));
            checkItemsMap.put("searchMessage", summaryLayoutStr.get("searchMessage"));
            checkItemsMap.put("cardState", summaryLayoutStr.get("cardState"));
        }
        else {
            if (!StringUtils.isEmpty(reapprovalInfoComment)) {
                checkItemsMap.put("summaryLayout", reapprovalInfoComment);
            }
        }

        String checkItemsStr = "";
        if (backlogBO.getCheckItems() != null) {
            checkItemsStr = backlogBO.getCheckItems().get(0).get("item").toString();
            if (backlogBO.getCheckItems().get(0).get("value") != null) {
                int value_i = Integer.parseInt(backlogBO.getCheckItems().get(0).get("value").toString());
                if (value_i != 0) {
                    checkItemsStr = checkItemsStr + backlogBO.getCheckItems().get(0).get("value").toString();
                }
            }

            checkItemsMap.put("checkItems", checkItemsStr);
        }
        if (backlogBO.getOperation() != null) {
            String operationStr = backlogBO.getOperation();
            checkItemsMap.put("operation", operationStr);
        }
        if (!CollectionUtils.isEmpty(backlogBO.getTodoItems())) {
            String todoItemStr = backlogBO.getTodoItems().get(0).get("item").toString();
            checkItemsMap.put("todoItems", todoItemStr);
        }
        if (backlogBO.getError() != null) {
            checkItemsMap.put("error", backlogBO.getError().get("error").toString());
        }

        // 设置卡面呈现配置
        cardPresentConfigQryService.setCardPresentConfigs(checkItemsMap,TmPageName.TASK_CARD_NAME.getValue());

        return checkItemsMap;
    }

    public Backlog getOriginalBacklog(Long overdueWorkitemId) {
        BpmActivityWorkitem originalWorkitem = bpmActivityWorkitemMapper.selectById(overdueWorkitemId);
        if (originalWorkitem != null) {
            Backlog backlog = backlogMapper.selectFirstByActivityStepId(originalWorkitem.getActivityStepId());
            return backlog;
        }
        else {
            // PTM
            return commonPtmTransformService.translateBacklogById(overdueWorkitemId);
        }
    }

    public void setCheckItems(AuthoredUser authoredUser, BacklogBO backlogBO) {
        if (Objects.equals(GlobalConstant.OVERDUE_WORKITEM_PATTER, backlogBO.getTmPattern())
                && Objects.equals(GlobalConstant.OVERDUE_WORKITEM_CATEGORY, backlogBO.getTmCategory())) {
            return;
        }
        String tmTaskId = backlogBO.getTmTaskId();

        TmActivityResponseDTO themeActivity = themeMapService.getActivityAction(tmTaskId, backlogBO.getTmActivityId(),
                TmPageName.TASK_CARD_NAME.getValue());
        backlogBO.setSubName(themeActivity.getStartApproveActivityName());

        if (Objects.equals("MECHANISM", backlogBO.getTmPattern())
                && Objects.equals("SUGGESTION", backlogBO.getTmCategory())) {
            setReasonToCheckItems(backlogBO, themeActivity);
            return;
        }
        else if (Objects.equals("MECHANISM", backlogBO.getTmPattern())
                && Objects.equals("APPROVAL", backlogBO.getTmCategory())) {
            setMechanismAppovalCheckItems(backlogBO, themeActivity);
            return;
        }
        else if (Objects.equals("ADJUSTMENT", backlogBO.getTmPattern())
                && Objects.equals("ADJUSTMENT", backlogBO.getTmCategory())) {
            setReasonToCheckItems(backlogBO, themeActivity);
            return;
        }
        else if (Objects.equals("MECHANISM", backlogBO.getTmPattern())
                && Objects.equals("POSITIONSUGGESTION", backlogBO.getTmCategory())) {
            setReasonToCheckItems(backlogBO, themeActivity);
            return;
        }
        else if (Objects.equals("MECHANISM", backlogBO.getTmPattern())
                && Objects.equals("POSITIONAPPROVAL", backlogBO.getTmCategory())) {
            setReasonToCheckItems(backlogBO, themeActivity);
            return;
        }

        boolean needCountData = true;
        if (themeActivity.hasCheckItems()) {
            backlogBO.setCheckItems(ActivityUtils.getCheckItemsResult(themeActivity.getCheckItems(), 0));
            needCountData = false;
        }

        // 设置建议操作
        if (themeActivity.hasOperations()) {
            Optional<TmOperationDTO> tmOperation = themeActivity.getPages().getOperations().stream().findFirst();
            tmOperation.ifPresent(tmOperationDTO -> backlogBO.setOperation(tmOperationDTO.getDescription()));

            needCountData = false;
        }

        if (themeActivity.existSummaryFields()) {
            needCountData = false;
        }

        if (needCountData) {
            setTodo(authoredUser, backlogBO);
        }

        backlogBO.setBpmActivityId(null);
    }

    private Map setSummaryLayoutStr(AuthoredUser authoredUserm, BacklogBO backlogBO, boolean needHistoryInfo) {
        Object activityData = bpmBacklogActionCreateService.getEditActions(authoredUserm, backlogBO.getId(), null);

        Map activityDataMap = (Map) activityData;
        activityDataMap.put("needHistoryInfo", needHistoryInfo);
        activityDataMap.put("calendar", backlogBO.getCalendar());
        List tasks = (List) activityDataMap.get("tasks");
        try {
            BaseResultDTO<Map> actionResponse = aglieService.getTaskCardAbstractStr(backlogBO.getTmTaskId(),
                    backlogBO.getTmActivityId(), backlogBO.getId(), activityDataMap,null,null);
            Map<String, Object> pageDataMap = actionResponse.getResponse();
            if (pageDataMap == null) {
                pageDataMap = new HashMap<>();
            }
            if (!CollectionUtils.isEmpty(tasks)) {
                Map task = (Map) tasks.get(0);
                if (task.containsKey("replyInvite")) {
                    ReplyTaskMessageDTO message = bpmWorkitemAppendixService.getReplyTaskMessage(backlogBO.getId());
                    if (message != null && !Objects.equals(message.getCode(), WorkitemAppendixType.ReSend.getValue())) {
                        pageDataMap.put(SUMMARY_LAYOUT_STR, message.getMessage());
                    }
                }
            }
            return pageDataMap;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
            Map<String, Object> error = new HashMap<>();
            error.put("error", e.getMessage());
            backlogBO.setError(error);
        }
        return null;
    }

    /**
     * 将reson设置checkItems
     *
     * @param backlogBO
     * @param tmActivityResponseDTO
     */
    public void setReasonToCheckItems(BacklogBO backlogBO, TmActivityResponseDTO tmActivityResponseDTO) {
        if (tmActivityResponseDTO.getPages() == null || tmActivityResponseDTO.getPages().getReason() == null) {
            return;
        }
        TmReasonDTO reasonDTO = tmActivityResponseDTO.getPages().getReason();

        List<Map<String, Object>> checkItems = new ArrayList<>();
        backlogBO.setCheckItems(checkItems);

        Map<String, Object> checkItemMap = new HashMap<>();
        checkItemMap.put("item", MessageUtils.getMessageByCurrentLanguage(reasonDTO.getTitle()));
        checkItems.add(checkItemMap);

        if (!"ADJUSTMENT".equals(tmActivityResponseDTO.getPattern()) && reasonDTO.getContent() != null) {
            // checkItemMap=new HashMap<>();
            // checkItemMap.put("item",MessageUtils.getMessageByCurrentLanguage(reasonDTO.getContent().getText()));
            // checkItems.add(checkItemMap);
            backlogBO.setOperation(MessageUtils.getMessageByCurrentLanguage(reasonDTO.getContent().getText()));
        }
    }

    /**
     * 机制型审核活动卡的checkItems特殊处理，使用新公式的每一项
     *
     * @param backlogBO
     * @param tmActivityResponseDTO
     */
    public void setMechanismAppovalCheckItems(BacklogBO backlogBO, TmActivityResponseDTO tmActivityResponseDTO) {
        Map<String, TmActionDTO> dataSources = tmActivityResponseDTO.getDataSources();
        if (MapUtils.isEmpty(dataSources) || !dataSources.containsKey("newFormulaData")) {
            return;
        }

        TmActionDTO newFormulaAction = (TmActionDTO) dataSources.get("newFormulaData");
        List<TmActionParameterDTO> paras = newFormulaAction.getActionParams();
        if (org.springframework.util.CollectionUtils.isEmpty(paras)) {
            return;
        }
        BpmActivity bpmActivity = bpmActivityMapper.selectById(backlogBO.getBpmActivityId());
        if (bpmActivity == null || bpmActivity.getData() == null) {
            return;
        }

        Optional<TmActionParameterDTO> formulaIdNameOption = paras.stream().findFirst();
        String formulaIdName = "";
        if (formulaIdNameOption.isPresent()) {
            formulaIdName = formulaIdNameOption.get().getValue();
        }

        String formulaId = bpmActivity.getData().getString(formulaIdName);
        Map formulaMap = themeMapService.executeFormula(formulaId);
        if (!formulaMap.containsKey("formulaVariables")) {
            return;
        }
        List<Map> formulaVariables = (List<Map>) formulaMap.get("formulaVariables");

        List<Map<String, Object>> checkItems = new ArrayList<>();
        backlogBO.setCheckItems(checkItems);
        for (Map m : formulaVariables) {
            Map<String, Object> map = new HashMap<>();
            map.put("item", m.get("name"));
            map.put("value", m.get("value"));
            checkItems.add(map);
        }
    }

    public void setTodo(AuthoredUser authoredUser, BacklogBO backlogBO) {
        // 是手动发起任务（行事历任务）
        if (ManualTaskUtil.isManualTask(backlogBO.getTmTaskId(), backlogBO.getTmActivityId())) {
            return;
        }

        Object activityData = bpmBacklogActionCreateService.getEditActions(authoredUser, backlogBO.getId(), null);
        try {
            BaseResultDTO<HashMap> actionResponse = aglieService.getTaskCardDataSize(backlogBO.getTmTaskId(),
                    backlogBO.getTmActivityId(), activityData);
            HashMap data = actionResponse.getResponse();

            if (data == null || data.size() == 0 || !data.containsKey("title")) {
                return;
            }
            List<Map<String, Object>> todo = new ArrayList<>();
            Map<String, Object> ci = new HashMap<>();

            String langName = getLangName(authoredUser.getUserId(), authoredUser.getToken());
            Map<String, Object> activityDataMap = (Map<String, Object>) activityData;
            if (activityDataMap.get("type") != null && Integer.parseInt(activityDataMap.get("type").toString()) == 89) {
                ci.put("item", String.format(
                        messageUtils.getMessageByLangName("data.uniformity.exception.size", langName), data.get("size")));
            }
            else {
                String item = MessageFormat.format("{0}{1}{2}", data.get("title"), data.get("size"),
                        messageUtils.getMessageByLangName("data.summary.term", langName));
                if (data.containsKey("abnormalSize") && Integer.parseInt(data.get("abnormalSize").toString()) > 0) {
                    item = item + "，"
                            + String.format(messageUtils.getMessageByLangName("data.uniformity.abnormal.size", langName),
                            data.get("abnormalSize"));
                }
                ci.put("item", item);
            }
            todo.add(ci);
            backlogBO.setTodoItems(todo);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
            Map<String, Object> error = new HashMap<>();
            error.put("error", e.getMessage());
            backlogBO.setError(error);
        }
    }

    /**
     * 获取语言
     *
     * @param userId
     * @param token
     * @return
     */
    private String getLangName(String userId, String token) {

        // 优先取header 传入的语言
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes) (RequestContextHolder
                .currentRequestAttributes())).getRequest();
        String locale = httpServletRequest.getHeader("Locale");
        if (StringUtils.isNotBlank(locale)) {
            return locale;
        }
        // 查询用户语言设置
        String langName = userService.getUserLangMetadataAllTenant(userId, token);
        if (StringUtils.isNotBlank(langName)) {
            return langName;
        }
        // 如果上面都未获取到语言类别，返回默认值
        return "zh_TW";
    }

}
