package com.digiwin.athena.abt.application.service.atmc.migration.backlog;


import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.CardColumn;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.QueryResult;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.QueryResultSet;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskDefCodeData;
import lombok.extern.slf4j.Slf4j;

import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class TodoBacklogQueryService {

    public Map<String, Map<String, Object>> getDataFields(List<CardColumn> columnRuleList, String application, List<Map<String, Object>> labelRuleList, List<TaskDefCodeData> groupRuleList, QueryResultSet resultSet, List<String> bkList, String tmActivityId) {
        Map<String, Map<String, Object>> result = new HashMap<>();
        if (bkList == null || bkList.isEmpty()) {
            return result;
        }
        try {
            QueryResult queryResult = resultSet.getQueryResults().get(0);
            queryResult.getData().forEach(e -> {
                final String[] bzKey = new String[bkList.size()];
                for (int i = 0; i < bkList.size(); i++) {
                    if (e.get(bkList.get(i)) != null) {
                        bzKey[i] = e.get(bkList.get(i)).toString();
                    }
                }
                //保持跟之前bkContact一致
                String key = String.join("$&", bzKey);
                Map<String, Object> data = new HashMap<>();
                Map<String, String> groupDataMap = new HashMap<>();
                List<Map<String, Object>> labelDataList = new ArrayList<>();
                Map<String, String> orderDataMap = new HashMap<>();

                groupDataMap = parseGroup(application, groupRuleList, e, tmActivityId);
                labelDataList = parseLabel(labelRuleList, e, tmActivityId);
                List<Map<String, String>> columnValues = parseColumn(columnRuleList, e, tmActivityId);
                data.put("group", groupDataMap);
                data.put("label", labelDataList);
                data.put("order", orderDataMap);
                data.put("columns", columnValues);
                result.put(key, data);

            });
        } catch (Exception e) {
            e.printStackTrace();
        }

        return result;
    }

    private Map<String, String> parseGroup(String application, List<TaskDefCodeData> groupRuleList, Map<String, Object> dataFields, String tmActivityId) {
        Optional<TaskDefCodeData> taskDefCodeData = groupRuleList.stream().filter(e -> e.getTaskCode().equals(tmActivityId)).findFirst();
        Map<String, String> result = new HashMap<>();
        if (taskDefCodeData.isPresent()) {
            TaskDefCodeData codeData = taskDefCodeData.get();
            result.put("code", application + "-" + codeData.getBkCode());
            result.put("name", codeData.getName());
            result.put("groupName", dataFields.get(codeData.getBkCode()).toString());
            result.put("groupCode", application + "-" + codeData.getBkCode() + "-" + dataFields.get(codeData.getBkCode()));
        }
        if (result.get("groupName") == null || "".equals(result.get("groupName"))) {
            return new HashMap<>();
        }
        return result;
    }

    private List<Map<String, Object>> parseLabel(List<Map<String, Object>> labelKeys, Map<String, Object> dataFields, String tmActivityId) {
        List<Map<String, Object>> resultList = new ArrayList<>();
        Optional<Map<String, Object>> taskDefCodeData = labelKeys.stream().filter(e -> e.get("taskCode").equals(tmActivityId)).findFirst();
        List<Map<String, Object>> labelList;
        if (taskDefCodeData.isPresent()) {
            Map<String, Object> codeData = taskDefCodeData.get();
            List<Map<String, Object>> labels = (List<Map<String, Object>>) codeData.get("labels");
            //仅保留两个标签
            if (labels == null) {
                return resultList;
            }
            if (labels.size() > 2) {
                labels = labels.stream().limit(2).collect(Collectors.toList());
            }
            labels.forEach(label -> {
                Map<String, Object> result = new HashMap<>();
                Map<String, Object> labelField = label;

                switch (labelField.get("obtainType").toString()) {
                    case "match":
                        result.put("type", "complex");
                        result.put("code", labelField.get("code"));
                        result.put("name", labelField.get("name"));
                        String value = dataFields.get(labelField.get("code")).toString();
                        List<Map<String, Object>> returnFields = (List<Map<String, Object>>) labelField.get("returnFields");
                        returnFields.forEach(e -> {
                            if (e.get("value").toString().equals(value)) {
                                result.put("value", e.get("name").toString());
                                result.put("orderWeight", e.get("orderWeight").toString());
                                Map<String, String> style = new HashMap<>();
                                Map<String, String> mongoStyle = (Map<String, String>) e.get("style");
                                style.put("color", mongoStyle.get("color"));
                                result.put("style", style);
                            }
                        });
                        break;
                    case "ordinary":
                        result.put("type", "complex");
                        result.put("code", labelField.get("code"));
                        result.put("name", labelField.get("name"));
                        result.put("value", dataFields.get(labelField.get("code")).toString());
                        List<Map<String, Object>> returnFieldsSimple = (List<Map<String, Object>>) labelField.get("returnFields");
                        Map<String, String> style = new HashMap<>();
                        if (returnFieldsSimple.size() == 1) {
                            Map<String, String> mongoStyle = (Map<String, String>) returnFieldsSimple.get(0).get("style");
                            style.put("color", mongoStyle.get("color"));
                            result.put("style", style);
                        }
                        break;

                }
                if (result.get("value") != null && !"".equals(result.get("value"))) {
                    resultList.add(result);
                }
            });
        }
        return resultList;
    }
    private List<Map<String, String>> parseColumn(List<CardColumn> columnRuleList, Map<String, Object> dataFields, String tmActivityId) {
        List<Map<String, String>> result = new ArrayList<>();
        columnRuleList.stream().filter(e -> e.getTaskCode().equals(tmActivityId)).forEach(e -> {
            Map<String, String> element = new HashMap<>();
            if (dataFields.get(e.getCode()) != null) {
                element.put(e.getCode(), dataFields.get(e.getCode()).toString());
                result.add(element);
            }
        });
        return result;
    }

}
