package com.digiwin.athena.abt.application.service.atmc.migration.bk;

import com.digiwin.athena.abt.application.dto.migration.atmc.bk.BkNode;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.MetadataUnit;
import com.digiwin.athena.abt.core.meta.constants.Constant;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author zhangzhi@digiwin.com
 * @date 2021/11/22
 */
public abstract class AbstractBkMetadataParser {

    /**
     * 构建元数据定义
     *
     * @param metaObj
     * @param rootName
     * @return
     */
    public static MetadataUnit constructMetadata(JSONObject metaObj, String rootName) {
        String entityName = metaObj.getString(Constant.Metadata.ENTITY_NAME);
        String source = "";
        if(metaObj.containsKey(source)){
            source = metaObj.getString(Constant.Metadata.SOURCE);
        }
        JSONArray bks = metaObj.getJSONArray(Constant.Metadata.BK);
        boolean isRoot = false;
        // 保证与bkInfo配置中的顺序一致
        Map<String, BkNode> bkFields = new LinkedHashMap<>(8);
        for (Object bk : bks) {
            JSONObject tempBk = (JSONObject) bk;
            if (Constant.Metadata.OBJECT_DATATYPE.equals(tempBk.getString(Constant.Metadata.DATA_TYPE))) {
                String parentPath = tempBk.getString(Constant.Metadata.DATA_NAME) + ".";
                JSONArray fieldBks = tempBk.getJSONArray(Constant.Metadata.FIELD);
                fieldBks.forEach(fieldBk -> recursion((JSONObject) fieldBk, bkFields, parentPath,tempBk.getBoolean(Constant.Metadata.IS_ARRAY)));
            }
            /** 如果根节点下直接存在bk节点，需要在jsonPath路径前追加rootName信息，后续解析需要根据此进行逻辑处理 */
            if (!Constant.Metadata.OBJECT_DATATYPE.equals(tempBk.getString(Constant.Metadata.DATA_TYPE))) {
                String bkName = null;
                if(tempBk.containsKey(Constant.Metadata.BK_NAME)){
                    bkName = tempBk.getString(Constant.Metadata.BK_NAME);
                }
                bkName = StringUtils.isBlank(bkName) ? tempBk.getString(Constant.Metadata.DATA_NAME) : tempBk.getString(Constant.Metadata.BK_NAME);
                bkFields.put(bkName, new BkNode(bkName, rootName, bkName, tempBk.getBoolean(Constant.Metadata.IS_ARRAY)));
                isRoot = true;
            }
        }

        /** 如果存在根节点下直接有bk的情况，其余jsonPath中也需要遍历追加rootName的定义
         if (isRoot) {
         bkFields.entrySet().forEach(entry -> {
         if (!entry.getValue().getNodePath().startsWith(rootName)) {
         entry.getValue().setNodePath(rootName + "." + entry.getValue().getNodePath());
         }
         });
         }*/

        return new MetadataUnit(source, entityName, bkFields, isRoot);
    }

    private static void recursion(JSONObject tempBk, Map<String, BkNode> bkFields, String parentPath,boolean parentIsArray) {
        if (Constant.Metadata.OBJECT_DATATYPE.equals(tempBk.getString(Constant.Metadata.DATA_TYPE))) {
            String tempParentPath = parentPath + tempBk.getString(Constant.Metadata.DATA_NAME) + ".";
            JSONArray fieldBks = tempBk.getJSONArray(Constant.Metadata.FIELD);
            fieldBks.forEach(fieldBk -> recursion((JSONObject) fieldBk, bkFields, tempParentPath,tempBk.getBoolean(Constant.Metadata.IS_ARRAY)));
        }
        if (!Constant.Metadata.OBJECT_DATATYPE.equals(tempBk.getString(Constant.Metadata.DATA_TYPE))) {
            String bkName = null;
            if(tempBk.containsKey(Constant.Metadata.BK_NAME)){
                bkName = tempBk.getString(Constant.Metadata.BK_NAME);
            }
            bkName = StringUtils.isBlank(bkName) ? tempBk.getString(Constant.Metadata.DATA_NAME) : tempBk.getString(Constant.Metadata.BK_NAME);
            String nodePath = parentPath + tempBk.getString(Constant.Metadata.DATA_NAME);
            String parentRealPath = parentPath.substring(0, parentPath.length() - 1);
            bkFields.put(bkName, new BkNode(bkName, parentRealPath, nodePath, parentIsArray));
        }
    }
}
