package com.digiwin.athena.abt.application.service.atmc.migration.bk;

import com.digiwin.athena.abt.application.dto.migration.atmc.mongodb.MongodbService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.BKUtils;
import com.digiwin.athena.abt.core.meta.constants.BkConstant;
import com.digiwin.athena.abt.core.meta.dto.IndexData;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.time.LocalDateTime;
import java.util.*;

/**
 * @author：SYQ
 * @date：2021/12/6
 */
@Slf4j
@Service
public class BkTaskActivityService {

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private MongodbService mongodbService;

    //用于存储任务定义中的dataSources
    Map<String, Object> tmActivityDataSourceMap = new HashMap<>();

    /**
     * 新增原始bk和卡片的关系
     *
     * @Author：SYQ
     * @Date：2022/1/6 14:48
     */
    public void insertOriBk(List<JSONObject> oriBkList, List<Object> oriObjBkList, Long cardId, String tenantId, String type) {
        insertOriBk(oriBkList, oriObjBkList, cardId, tenantId, type, "ori");
    }

    /**
     * 新增原始bk和卡片的关系
     *
     * @Author：majfa
     * @Date：2022/11/24 14:48
     */
    public void insertOriBk(List<JSONObject> oriBkList, List<Object> oriObjBkList, Long cardId, String tenantId, String type, String source) {
        //集合名称
        String collectionName = tenantId;
        IndexData indexData = new IndexData();
        indexData.append(BkConstant.CARD_ID, BkConstant.ASC);
        indexData.append(BkConstant.SEARCH_INDEX_PREFIX, BkConstant.ASC);
        mongodbService.createCollectionLock(collectionName, indexData.getIndexList());

        //新增数据
        List<Map> dataList = new ArrayList<>();
        for (JSONObject bk : oriBkList) {
            Map<String, Object> dataMap = new HashMap<>();
            String bkStr = JsonUtils.objectToString(bk);
            String bkContent = bkStr.replaceAll("[{}\\\"]", "").replace(",", "&");
            TreeMap treeMap = JsonUtils.jsonToObject(bkStr, TreeMap.class);
            dataMap.put("bk", treeMap);

            TreeMap bkSortMap = BKUtils.recursionToTreeMap(bk);
            String searchJsonStr = JsonUtils.objectToString(bkSortMap);
            String searchContent = searchJsonStr.replaceAll("[{}\\\"]", "").replace(",", "&");
            dataMap.put(BkConstant.SEARCH_CONTENT, searchContent);
            dataMap.put(BkConstant.BK_CONTENT, bkContent);
            dataMap.put(BkConstant.CARD_ID, cardId);
            dataMap.put("type", type);
            dataMap.put(BkConstant.TENANT_ID, tenantId);
            dataMap.put(BkConstant.CREATE_DATE, LocalDateTime.now());
            dataMap.put(BkConstant.MODIFY_DATE, LocalDateTime.now());
            dataMap.put(BkConstant.SOURCE, source);
            //生成bkSearch字段信息，作为bk查询的索引字段
            List<Map<String, Object>> bkSearchList = BKUtils.convertBkIndex(bk);
            dataMap.put(BkConstant.SEARCH_PREFIX, bkSearchList);
            dataMap.put(BkConstant.BK_INDEX_STATE, BkConstant.INDEX_STATE_CREATE);
            dataList.add(dataMap);
        }
        for (Object bk : oriObjBkList) {
            Map<String, Object> dataMap = new HashMap<>();
            dataMap.put("bk", bk);
            dataMap.put(BkConstant.BK_CONTENT, bk);
            dataMap.put(BkConstant.CARD_ID, cardId);
            dataMap.put("type", type);
            dataMap.put(BkConstant.TENANT_ID, tenantId);
            dataMap.put(BkConstant.CREATE_DATE, LocalDateTime.now());
            dataMap.put(BkConstant.MODIFY_DATE, LocalDateTime.now());
            dataMap.put(BkConstant.SOURCE, source);
            //生成bkSearch字段信息，作为bk查询的索引字段
            List<Map<String, Object>> bkSearchList = BKUtils.convertBkIndexSimple(bk);
            dataMap.put(BkConstant.SEARCH_PREFIX, bkSearchList);
            dataMap.put(BkConstant.BK_INDEX_STATE, BkConstant.INDEX_STATE_CREATE);
            dataList.add(dataMap);
        }
        log.info("{}", cardId);
        mongodbService.insert(dataList, collectionName);
    }


    /**
     * 获取数据源中的businessKey
     *
     * @Author：SYQ
     * @Date：2022/3/10 14:07
     */
    public Map<String, Object> getTmBusinessKeyNew(String tmTaskId, String tmActivityId, JSONObject bpmData) {
        Map<String, Object> resultMap = new HashMap<>();
        //bk值集合
        List<JSONObject> bkValueList = new ArrayList<>();
        List<Object> bkObjectValueList = new ArrayList<>();
        //获取数据源
        Map<String, Object> dataSourcesMap = null;
        if (tmActivityDataSourceMap.containsKey(tmTaskId + tmActivityId) && tmActivityDataSourceMap.get(tmTaskId + tmActivityId) != null) {
            dataSourcesMap = (Map) tmActivityDataSourceMap.get(tmTaskId + tmActivityId);
        } else {
            //获取任务定义
            Map tmActivityMap = themeMapService.getActivityAction2(tmTaskId, tmActivityId, TmPageName.TASK_DETAIL_NAME.getValue());
            if (tmActivityMap != null && tmActivityMap.size() > 0) {
                //获取数据源
                dataSourcesMap = tmActivityMap.containsKey("dataSources") ? (Map) tmActivityMap.get("dataSources") : null;
            }
        }
        if (dataSourcesMap == null || dataSourcesMap.size() == 0) {
            return resultMap;
        }
        //获取key
        Set<String> businessKeySet = new HashSet<>();
        for (Map.Entry<String, Object> entry : dataSourcesMap.entrySet()) {
            getTmActivityParams(businessKeySet, entry.getValue());
        }
        //从bpmData中解析出业务数据
        for (String key : businessKeySet) {
            if (!bpmData.containsKey(key) || bpmData.get(key) == null) {
                continue;
            }
            //集合
            if (bpmData.get(key) instanceof Collection) {
                JSONArray jsonArray = bpmData.getJSONArray(key);
                jsonArray.forEach(obj -> bkValueList.add(JSONObject.fromObject(JsonUtils.objectToString(obj))));
            } else if (bpmData.get(key) instanceof Map) {//对象
                bkValueList.add(bpmData.getJSONObject(key));
            } else {
                bkObjectValueList.add(bpmData.get(key));
            }
        }
        if (!CollectionUtils.isEmpty(bkValueList)) {
            resultMap.put(BkConstant.BK_COMPLEX, bkValueList);
        }
        if (!CollectionUtils.isEmpty(bkValueList)) {
            resultMap.put(BkConstant.BK_SIMPLE, bkObjectValueList);
        }

        return resultMap;
    }

    /**
     * 递归获取任务定义中的actionParams
     *
     * @Author：SYQ
     * @Date：2022/3/10 13:36
     */
    private void getTmActivityParams(Set<String> businessKeySet, Object dataObj) {
        if (dataObj instanceof Collection) {
            List<Object> list = JSONArray.fromObject(dataObj);
            for (Object object : list) {
                getTmActivityParams(businessKeySet, object);
            }
        } else if (dataObj instanceof Map) {
            Map<String, Object> map = JSONObject.fromObject(dataObj);
            if (!map.containsKey(BkConstant.ACTION_PARAMS) || map.get(BkConstant.ACTION_PARAMS) == null) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    getTmActivityParams(businessKeySet, entry.getValue());
                }
            } else {
                List<JSONObject> tmActionParameterDTOS = JSONArray.fromObject(map.get(BkConstant.ACTION_PARAMS));
                for (JSONObject parameterDTO : tmActionParameterDTOS) {
                    if ("PROCESS_VARIABLE".equals(parameterDTO.get("type"))) {
                        businessKeySet.add(parameterDTO.getString("value"));
                        break;
                    }
                }
            }
        }
    }


}
