package com.digiwin.athena.abt.application.service.atmc.migration.bk.impl;

import com.digiwin.athena.abt.application.dto.migration.atmc.parser.IMetadataUnit;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.TaskBkMetadata;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.AbstractBkMetadataParser;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.IBkMetadataParser;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.constants.Constant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhangzhi@digiwin.com
 * @date 2021/11/22
 */
@Service("taskBkMetadataParser")
public class TaskBkMetadataParser extends AbstractBkMetadataParser implements IBkMetadataParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskBkMetadataParser.class);

    @Autowired
    private ThemeMapService themeMapService;

    @Override
    public IMetadataUnit parse(String queryCode, String queryType, AuthoredUser user) {
        JSONArray metaData = themeMapService.getTmTaskAndActivityBk(queryType, queryCode, user);
        if (CollectionUtils.isEmpty(metaData)){
            return null;
        }
        /** NOTE 目前只按照数组中只存在一个bk进行处理，后续如果有多种业务场景，此处需要同步调整 */
        JSONObject metaObj = metaData.getJSONObject(0);
        return new TaskBkMetadata(constructMetadata(JsonUtils.jsonToObject(JsonUtils.objectToString(metaObj), JSONObject.class), Constant.Common.PROCESS_VAR));
    }
}
