package com.digiwin.athena.abt.application.service.atmc.migration.bpm.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.bpm.BpmTaskApprovePreviousActivityDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.bpm.BpmTaskPreApproveRequestDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.bpm.TaskEngineService;
import com.digiwin.athena.abt.core.meta.constants.TaskEngineApiConstant;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class TaskEngineServiceImpl implements TaskEngineService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    /**
     *查询指定任务可退回重签信息
     * @param requestDTO
     * @return
     */
    @Override
    public BpmTaskApprovePreviousActivityDTO queryPreApprove(BpmTaskPreApproveRequestDTO requestDTO) {
        BpmTaskApprovePreviousActivityDTO result = null;

        //请求地址 由taskEngineUrl修改为ptmUri
        String url = envProperties.getPtmUri() + TaskEngineApiConstant.TASK_APPROVE_WORK_PREVIOUS_ACTIVITIES;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String,Object> rootPara = new HashMap<>();
        rootPara.put("locale", requestDTO.getLocale());
        rootPara.put("workitemId", requestDTO.getWorkitemId());

        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<BpmTaskApprovePreviousActivityDTO>> responseEntity = restTemplate.exchange(url, HttpMethod.POST,httpEntity,new ParameterizedTypeReference<BaseResultDTO<BpmTaskApprovePreviousActivityDTO>>(){}, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        return result == null ? new BpmTaskApprovePreviousActivityDTO() : result;
    }

}
