package com.digiwin.athena.abt.application.service.atmc.migration.history;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.tenantToken.TenantTokenService;
import com.digiwin.athena.abt.core.meta.constants.BpmConstant;
import com.digiwin.athena.abt.core.meta.constants.GlobalConstant;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskBacklogHistoryMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmMergeBacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmAgentPerformerDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskBacklogHistoryDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;

import com.jugg.agile.framework.core.config.JaProperty;
import lombok.extern.slf4j.Slf4j;

import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.athena.abt.core.meta.constants.GlobalConstant.*;

/**
 * @author：SYQ
 * @date：2021/6/3
 */
@Slf4j
@Service
public class TaskBacklogHistoryService {
    @Autowired
    private TaskBacklogHistoryMapper historyMapper;

    @Autowired
    private TaskMapper taskMapper;

    @Autowired
    private PtmService ptmService;

    @Autowired
    private TenantTokenService tenantTokenService;

    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    UserService userService;

    /**
     * 排序——降序
     */
    public static final String ORDER_TYPE_DESC = "desc";

    /**
     * 排序——升序
     */
    public static final String ORDER_TYPE_ASC = "asc";

    /**
     * 获取历史项目和任务
     *
     * @Author：SYQ
     * @Date：2021/6/4 16:41
     */
    public IPage<TaskBacklogHistoryDTO> findTaskBacklogH(AuthoredUser user, Map<String, Object> paramMap) {
        // sd归档数据查询条件
//        addArchiveParams(paramMap);
        // 外层查询条件
        LambdaQueryWrapper<TaskBacklogHistoryDTO> queryWrapper = buildQueryWrapper(paramMap);
        // 子查询条件
        buildQueryCondition(user, paramMap);
        // 分页信息
        Page<TaskBacklogHistoryDTO> page = buildPage(paramMap);
        //关闭自动查count
        page.setSearchCount(false);
//        int count = historyMapper.findHistoryPageCount(queryWrapper, paramMap);
        // 字段排序
        buildQueryOrderWrapper(queryWrapper, paramMap);

        //查询项目、任务已关闭数据
        IPage<TaskBacklogHistoryDTO> pageList = historyMapper.findHistoryPage(queryWrapper, paramMap, page);
        pageList = batchAddProxyInfo(pageList);
//        pageList.setTotal(count);
        //判断是否存在已关闭的任务和数据
        if (pageList.getRecords().size() == 0) {
            return pageList;
        }
        //处理数据，处理名称、状态、资讯等
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter formatterTo = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//        String langName = userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        //处理数据 设置卡片状态/来源/去向
        //setCardTraceAndState(pageList.getRecords(),user.getUserId());
        List<Long> backlogIdList = pageList.getRecords().stream()
                .filter(t -> !"0".equals(t.getType())
                        && Objects.equals(t.getDataFrom(), BpmConstant.DATA_FROM_PTM)
                        && t.getMerge()).map(TaskBacklogHistoryDTO::getId)
                .collect(Collectors.toList());
        Map<Long, PtmMergeBacklogBO> ptmMergeBacklogDTOMap = commonPtmTransformService.dealBacklogData(backlogIdList, true);

        List<Long> taskIdList = pageList.getRecords().stream()
                .filter(t -> "0".equals(t.getType())).map(TaskBacklogHistoryDTO::getId)
                .collect(Collectors.toList());
        List<Task> tasks = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(taskIdList)) {
            tasks = taskMapper.queryByMainTaskIdIds(taskIdList);
        }

        for (TaskBacklogHistoryDTO historyDTO : pageList.getRecords()) {
//            String taskTargetName = MessageUtils.getMessageByLanguage(historyDTO.getDefName(), langName);
            String taskTargetName = MessageUtils.getMessageByCurrentLanguage(historyDTO.getDefName());
            historyDTO.setDefName(taskTargetName);
            String endTimeStr = historyDTO.getEndTime().format(formatter) + " 23:59:59";
            LocalDateTime endTime = LocalDateTime.parse(endTimeStr, formatterTo);
            historyDTO.setEndTime(endTime);

            historyDTO.setName(MessageUtils.getMessageByCurrentLanguage(historyDTO.getName()));
            historyDTO.setBacklogTaskName(MessageUtils.getMessageByCurrentLanguage(historyDTO.getBacklogTaskName()));
            // 所属项目名称
            historyDTO.setProjectName(MessageUtils.getMessageByCurrentLanguage(historyDTO.getProjectName()));
            // 所属项目类型名称
            historyDTO.setProjectDefName(MessageUtils.getMessageByCurrentLanguage(historyDTO.getProjectDefName()));

            String type = historyDTO.getType();
            // 处理代理 逾期/提前时间
            historyDTO.setExtraTimeMap(getExtraTimeMap(historyDTO.getState(), historyDTO.getClosedTime(),
                    historyDTO.getStartTime(), historyDTO.getEndTime()));
            if ("0".equals(type)) {
                dealTaskH(historyDTO, tasks);
            } else {
                dealBacklogH(historyDTO, ptmMergeBacklogDTOMap);
            }
        }
        return pageList;
    }

    /**
     * 构造查询排序
     *
     * @param paramMap
     * @return
     */
    private void buildQueryOrderWrapper(LambdaQueryWrapper<TaskBacklogHistoryDTO> queryWrapper, Map<String, Object> paramMap) {

        if (!paramMap.containsKey("orderList")) {
            // 默认按实际完成日期倒序排序
            queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getClosedTime);
            return;
        }

        List<Map<String, Object>> orderList = (List<Map<String, Object>>) paramMap.get("orderList");
        if (CollectionUtils.isEmpty(orderList)) {
            // 默认按实际完成日期倒序排序
            queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getClosedTime);
            return;
        }

        // 按照order排序
        List<Map<String, Object>> newOrderList = orderList.stream().sorted(Comparator.comparing(o -> (int) o.get("order"))).collect(Collectors.toList());
        for (Map<String, Object> order : newOrderList) {
            String schema = order.get("schema").toString();
            String orderType = order.get("orderType").toString();
            if ("defName".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getDefName);
                } else if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getDefName);
                } else {
                    log.error("orderType:{} is not exist", orderType);
                }
            } else if ("type".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getType);
                } else if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getType);
                } else {
                    log.error("orderType:{} is not exist", orderType);
                }
            } else if ("name".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getName);
                } else if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getName);
                } else {
                    log.error("orderType:{} is not exist", orderType);
                }
            } else if ("closedTime".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getClosedTime);
                } else if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getClosedTime);
                } else {
                    log.error("orderType:{} is not exist", orderType);
                }
            } else if ("projectName".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getProjectName);
                } else if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getProjectName);
                } else {
                    log.error("orderType:{} is not exist", orderType);
                }
            } else if ("projectDefName".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getProjectDefName);
                } else if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getProjectDefName);
                } else {
                    log.error("orderType:{} is not exist", orderType);
                }
            } else if ("projectStartTime".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getProjectStartTime);
                } else if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getProjectStartTime);
                } else {
                    log.error("orderType:{} is not exist", orderType);
                }
            } else if ("projectEndTime".equals(schema)) {
                if (ORDER_TYPE_DESC.equals(orderType)) {
                    queryWrapper.orderByDesc(TaskBacklogHistoryDTO::getProjectEndTime);
                } else if (ORDER_TYPE_ASC.equals(orderType)) {
                    queryWrapper.orderByAsc(TaskBacklogHistoryDTO::getProjectEndTime);
                } else {
                    log.error("orderType:{} is not exist", orderType);
                }
            } else {
                log.error("schema:{} is not support order!", schema);
            }
        }
    }


    /**
     * 处理任务数据
     *
     * @Author：SYQ
     * @Date：2021/6/3 9:47
     */
    private void dealBacklogH(TaskBacklogHistoryDTO historyDTO, Map<Long, PtmMergeBacklogBO> ptmMergeBacklogDTOMap) {
        //是否是代理
        int isProxy = StringUtils.isEmpty(historyDTO.getProxyUserId()) ? 0 : 1;
        historyDTO.setIsProxy(isProxy);

        //ptm合并任务的预计完成时间区间
        if (Objects.equals(historyDTO.getDataFrom(), BpmConstant.DATA_FROM_PTM) && historyDTO.getMerge()) {
//            List<Long> backlogIdList = new ArrayList<>();
//            backlogIdList.add(historyDTO.getId());
//            Map<Long, PtmMergeBacklogBO> ptmMergeBacklogDTOMap = commonPtmTransformService.dealBacklogData(backlogIdList, true);
            if (MapUtils.isNotEmpty(ptmMergeBacklogDTOMap)) {
                PtmMergeBacklogBO ptmMergeBacklogBO = ptmMergeBacklogDTOMap.get(historyDTO.getId());
                if (ptmMergeBacklogBO != null) {
                    historyDTO.setPlanEndTimeMin(ptmMergeBacklogBO.getPlanEndTimeMin());
                    historyDTO.setPlanEndTimeMax(ptmMergeBacklogBO.getPlanEndTimeMax());
                }
            }
        }
    }


    /**
     * 获取项目历史数据
     *
     * @Author：SYQ
     * @Date：2021/6/4 11:38
     */
    private TaskBacklogHistoryDTO dealTaskH(TaskBacklogHistoryDTO historyDTO, List<Task> tasks) {
        /*项目指定结案信息 start*/
//        Map<String, Object> paramMap = new HashMap<>(2);
//        paramMap.put("main_task_id", historyDTO.getId());
//        //查询该项目下的所有子流程,是否存在备注信息
//        List<Task> taskList = taskMapper.selectByMap(paramMap);
        List<Task> taskList = tasks.stream().filter(t -> t.getMainTaskId().equals(historyDTO.getId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(taskList)) {
            return historyDTO;
        }
        //项目指定结案信息以及项目下任务关闭信息
        List itemList = new ArrayList<>();
        //子流程id集合
        List<Long> itemTaskIds = new ArrayList<>();
        //整理子流程关闭信息
        for (Task task : taskList) {
            String remark = task.getRemark();
            //子流程id
            itemTaskIds.add(task.getId());
            //若备注存在则记录指定结案信息
            if (!StringUtils.isEmpty(remark)) {
                //指定结案信息
                Map<String, Object> msgMap = new HashMap<>();
                msgMap.put("remark", JSONObject.fromObject(remark));
                itemList.add(msgMap);
            }
        }
        /*项目指定结案信息 end*/

        /*项目下任务逾期信息 start*/
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("type", 1);
        queryWrapper.eq("state", 0);

        Map<String, Object> historyParamMap = new HashMap<>(2);
        historyParamMap.put("backlogTaskIds", itemTaskIds);
        //获取项目下所有任务
        List<TaskBacklogHistoryDTO> backlogList = historyMapper.findHistoryByParam(queryWrapper, historyParamMap);
        if (CollectionUtils.isNotEmpty(backlogList)) {
            for (TaskBacklogHistoryDTO backlog : backlogList) {
                backlog.setName(MessageUtils.getMessageByCurrentLanguage(backlog.getName()));
                //获取逾期/提前时间
                backlog.setExtraTimeMap(getExtraTimeMap(backlog.getState(), backlog.getClosedTime(),
                        backlog.getStartTime(), backlog.getEndTime()));
                itemList.add(backlog);
            }
        }
        /*项目下任务逾期信息 end*/
        if (CollectionUtils.isNotEmpty(itemList)) {
            historyDTO.setItemTaskList(itemList);
        }
        return historyDTO;
    }

    /**
     * 外层查询条件
     *
     * @param paramMap
     * @return
     */
    private LambdaQueryWrapper<TaskBacklogHistoryDTO> buildQueryWrapper(Map<String, Object> paramMap) {
        //查询条件
        LambdaQueryWrapper<TaskBacklogHistoryDTO> queryWrapper = new LambdaQueryWrapper<>();
        boolean isKeyWordEmpty = StringUtils.isEmpty(paramMap.get("name"));
        String keyWord = isKeyWordEmpty ? null : paramMap.get("name").toString();
        if (!isKeyWordEmpty) {
            queryWrapper.and(wrapper -> {
                wrapper.like(TaskBacklogHistoryDTO::getName, keyWord).
                        or().
                        like(TaskBacklogHistoryDTO::getProjectName, keyWord).
                        or().
                        like(TaskBacklogHistoryDTO::getSummary, keyWord).
                        or().
                        like(TaskBacklogHistoryDTO::getHistoryMessage, keyWord).
                        or().
                        like(TaskBacklogHistoryDTO::getSearchMessage, keyWord).
                        or().
                        like(TaskBacklogHistoryDTO::getOldPerformerName, keyWord).
                        or().
                        like(TaskBacklogHistoryDTO::getDirectionPerformerName, keyWord);
            });
        }
        //卡片类型
        if (!StringUtils.isEmpty(paramMap.get("type"))) {
            queryWrapper.eq(TaskBacklogHistoryDTO::getType, paramMap.get("type"));
        }
        //状态
        if (!StringUtils.isEmpty(paramMap.get("state"))) {
            queryWrapper.eq(TaskBacklogHistoryDTO::getState, paramMap.get("state"));
        }
        if (!CollectionUtils.isEmpty((Collection) paramMap.get("defCodes"))) {
            queryWrapper.in(TaskBacklogHistoryDTO::getDefCode, (Collection) paramMap.get("defCodes"));
        }
        if (!CollectionUtils.isEmpty((Collection) paramMap.get("projectDefCodes"))) {
            queryWrapper.in(TaskBacklogHistoryDTO::getProjectDefCode, (Collection) paramMap.get("projectDefCodes"));
        }
        return queryWrapper;
    }

    /**
     * 子查询条件
     *
     * @param user
     * @param paramMap
     */
    private void buildQueryCondition(AuthoredUser user, Map<String, Object> paramMap) {
        paramMap.put("tenantId", user.getTenantId());
        paramMap.put("charge", user.getUserId());

        //处理开始时间
        Object startTimeObj = paramMap.get("startTime");
        if (!StringUtils.isEmpty(startTimeObj)) {
            String startTime = startTimeObj + " 00:00:00";
            paramMap.put("startTime", startTime);
        }
        //处理结束时间
        Object endTimeObj = paramMap.get("endTime");
        if (!StringUtils.isEmpty(endTimeObj)) {
            String endTime = endTimeObj + " 23:59:59";
            paramMap.put("endTime", endTime);
        }

        //代理任务
//        List<Long> agentBacklogIdList = ptmService.getCompleteAgentBacklog(user.getUserId());
//        if (!CollectionUtils.isEmpty(agentBacklogIdList)) {
//            paramMap.put("agentBacklogIds", agentBacklogIdList);
//        }

        //处理所属项目开始时间
        Object projectStartTimeObj = paramMap.get("projectStartTime");
        if (!StringUtils.isEmpty(projectStartTimeObj)) {
            String projectStartTime = projectStartTimeObj + " 00:00:00";
            paramMap.put("projectStartTime", projectStartTime);
        }
        //处理所属项目结束时间
        Object projectEndTimeObj = paramMap.get("projectEndTime");
        if (!StringUtils.isEmpty(projectEndTimeObj)) {
            String projectEndTime = projectEndTimeObj + " 23:59:59";
            paramMap.put("projectEndTime", projectEndTime);
        }

        //项目任务来源/去向
        this.buildCardTraceParameter(paramMap);
    }

    /**
     * 分页信息
     *
     * @param paramMap
     * @return
     */
    private Page<TaskBacklogHistoryDTO> buildPage(Map<String, Object> paramMap) {
        Object pageObj = paramMap.get("page");
        int page = StringUtils.isEmpty(pageObj) ? 0 : Integer.valueOf(pageObj.toString());
        Object rowsObj = paramMap.get("rows");
        int rows = StringUtils.isEmpty(rowsObj) ? 10 : Integer.valueOf(rowsObj.toString());
        return new Page<>(page, rows);
    }

    /**
     * 获取逾期/提前时间
     *
     * @Author：SYQ
     * @Date：2021/6/7 15:00
     */
    private Map<String, Object> getExtraTimeMap(String state, LocalDateTime closedTime,
                                                LocalDateTime startTime, LocalDateTime endTime) {
        //计算逾期/提前时间
        Duration duration = null;
        if (endTime == null || closedTime == null) {
            //兼容异常情况
            return countTimeNum(duration);
        }
        if ("0".equals(state)) { //逾期 关闭时间在结束时间之后
            duration = Duration.between(endTime, closedTime);
        } else if ("1".equals(state)) { //提前 关闭时间在开始时间之前
            duration = Duration.between(closedTime, startTime);
        }
        //获取逾期/提前时间
        return countTimeNum(duration);
    }


    /**
     * 计算逾期/提前时间
     *
     * @Author：SYQ
     * @Date：2021/6/4 11:07
     */
    private Map<String, Object> countTimeNum(Duration duration) {
        if (duration == null) {
            return null;
        }
        //天数
        long days = duration.toDays();
        //小时数
        long hours = duration.toHours();
        //分钟数
        long minutes = duration.toMinutes();
        //毫秒数
        long millis = duration.toMillis();

        //时间数
        Long timeNum = days;
        //单位
        String type = "day";

        //判断逾期/提前时间用哪种单位
        if (days < 1 && hours >= 1) {//不满1天并且大于等于1小时
            timeNum = hours;
            type = "hour";
        } else if (days < 1 && hours < 1 && minutes >= 1) {//不满1天并且不满1小时并且大于等于1分钟
            timeNum = minutes;
            type = "minute";
        } else if (days < 1 && hours < 1 && minutes < 1 && millis >= 1) {//不满1天并且不满1小时并且不满1分钟并且大于等于1毫秒
            //转为秒
            timeNum = millis / 1000;
            type = "second";
        }

        //记录结果
        Map<String, Object> resultMap = new HashedMap();
        resultMap.put("timeNum", timeNum);
        resultMap.put("type", type);

        return resultMap;
    }

    /**
     * 处理数据，增加代理token的信息
     *
     * @param pageList 数据集合
     * @return IPage
     */
    private IPage<TaskBacklogHistoryDTO> batchAddProxyInfo(IPage<TaskBacklogHistoryDTO> pageList) {
        //如果数据为空，则直接返回原对象处理
        if (null == pageList || null == pageList.getRecords()) {
            return pageList;
        }
        Map<Long, TaskBacklogHistoryDTO> tempMap = new HashMap<>();
        Map<Long, TaskBacklogHistoryDTO> agentMap = new HashMap<>();
        List<Long> queryLists = new ArrayList<>();
        List<Long> queryAgLists = new ArrayList<>();
        for (TaskBacklogHistoryDTO temp : pageList.getRecords()) {
            if (!"TaskEngine".equals(temp.getEngineType()) || !Objects.equals(temp.getType(), "1")) {
                if (!StringUtils.isEmpty(temp.getProxyToken())) {
                    temp.setProxyToken(tenantTokenService.queryVirtualToken(temp.getTenantId()));
                }
                continue;
            }

            queryLists.add(temp.getTaskId());
            queryAgLists.add(temp.getId());
            tempMap.put(temp.getTaskId(), temp);
            agentMap.put(temp.getId(), temp);
        }
        if (queryLists.isEmpty()) {
            return pageList;
        }
        //从PTM获取对应的数据信息，主要是为了获取代理token信息
        List<PtmTaskRecordBO> taskResult = ptmService.getTaskRecordByTaskIds(queryLists);
        List<PtmAgentPerformerDTO> agentList = ptmService.queryAgentPerformerList(queryAgLists);
        if (CollectionUtils.isNotEmpty(taskResult)) {
            for (PtmTaskRecordBO tempPtmDto : taskResult) {
                if (!tempMap.containsKey(tempPtmDto.getId())) {
                    continue;
                }
                TaskBacklogHistoryDTO historyDto = tempMap.get(tempPtmDto.getId());
                //如果存在代理token信息，则使用正确的租户查询出对应的代理token信息
                if (!StringUtils.isEmpty(tempPtmDto.getProxyToken())) {
                    historyDto.setProxyToken(tenantTokenService.queryVirtualToken(tempPtmDto.getTenantId()));
                }
            }
        }

        //如果存在服务代理人信息，获取代理人名称
        if (CollectionUtils.isNotEmpty(agentList)) {
            agentList.stream().forEach(agent -> {
                if (!agentMap.containsKey(agent.getBacklogId())) {
                    return;
                }
                TaskBacklogHistoryDTO historyDto = agentMap.get(agent.getBacklogId());
                historyDto.setPerformerType(agent.getPerformerType());
                historyDto.setProxyUserName(agent.getAgentPerformerName());
            });
        }

        return pageList;

    }

    private Map<String, String> getArchiveProperties() {
        String type = JaProperty.get(ARCHIVE_TYPE);
        String date = JaProperty.get(ARCHIVE_DATE);
        String periodDay = JaProperty.get(ARCHIVE_PERIOD_DAY);
        log.info(" archive properties type,date,periodDay:{},{},{}", type, date, periodDay);
        Map<String, String> map = new HashMap<>();
        map.put("type", type);
        map.put("date", date);
        map.put("periodDay", periodDay);
        return map;
    }

    private void addArchiveParams(Map<String, Object> paramMap) {
        try {
            Map<String, String> archiveProperties = getArchiveProperties();
            if (GlobalConstant.ARCHIVE_TYPE_DATE.equals(archiveProperties.get("type"))) {
                paramMap.put("closedTime", archiveProperties.get("date"));
            } else if (GlobalConstant.ARCHIVE_TYPE_PERIOD.equals(archiveProperties.get("type"))) {
                LocalDateTime today = LocalDateTime.now();
                int periodDays = Integer.parseInt(archiveProperties.get("periodDay"));
                LocalDateTime previousDateTime = today.minusDays(periodDays);
                LocalDateTime startOfDay = previousDateTime.withHour(0).withMinute(0).withSecond(0).withNano(0);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String formattedDateTime = startOfDay.format(formatter);
                paramMap.put("closedTime", formattedDateTime);
            }
        } catch (Exception e) {
            log.error(" add archive params error", e);
        }
    }

    /**
     * 构建项目任务来源去向条件
     *
     * @param paramMap 任务枚举：
     *                 sourceState字段枚举：
     *                 0  正常新增
     *                 1  轉派新增
     *                 2  退回重簽
     *                 3  退回重辦
     *                 4  加簽
     *                 9  撤回重辦
     *                 10  交接新增
     *                 directionState字段枚举：
     *                 0  正常提交
     *                 1  轉派新增
     *                 2  退回重簽
     *                 3  退回重辦
     *                 4  加簽
     *                 9  撤回重辦
     *                 10  交接新增
     *                 99  终止
     *                 项目枚举：
     *                 sourceState字段枚举：
     *                 1  转派
     *                 3  交接
     *                 0 正常新增
     */
    private void buildCardTraceParameter(Map<String, Object> paramMap) {
        String begineCreateDate = MapUtils.getString(paramMap, "begineCreateDate");
        String endCreateDate = MapUtils.getString(paramMap, "endCreateDate");
        if (StrUtil.isNotBlank(begineCreateDate)) {
            paramMap.put("begineCreateDate", begineCreateDate + " 00:00:00");
        }
        if (StrUtil.isNotBlank(endCreateDate)) {
            paramMap.put("endCreateDate", endCreateDate + " 23:59:59");
        }
        String type = MapUtils.getString(paramMap, "type");
        if (StrUtil.isBlank(type)) {
            //任务卡来源条件
            this.buildTaskCardSourceTraceParameter(paramMap);
            //任务卡去向条件
            this.buildTaskCardDirectionTraceParameter(paramMap);
            //项目卡来源条件
            this.buildProjectCardSourceTraceParameter(paramMap);
            return;
        }

        //项目卡
        if ("0".equals(type)) {
            //项目卡来源条件
            this.buildProjectCardSourceTraceParameter(paramMap);
            return;
        }
        //任务卡来源条件
        this.buildTaskCardSourceTraceParameter(paramMap);
        //任务卡去向条件
        this.buildTaskCardDirectionTraceParameter(paramMap);
    }

    /**
     * 构建任务卡来源条件
     *
     * @param paramMap
     */
    private void buildTaskCardSourceTraceParameter(Map<String, Object> paramMap) {
        List<Integer> taskSourceStates = MapUtil.get(paramMap, "source", List.class);
        if (CollectionUtil.isEmpty(taskSourceStates)) {
            return;
        }

        //2和3都属于退回，前端传2即可  后端搜索2和3状态信息
        boolean contains = taskSourceStates.contains(2);
        if (contains) {
            taskSourceStates.add(3);
        }
        paramMap.put("taskSourceStates", taskSourceStates);
    }

    /**
     * 构建任务卡去向条件
     *
     * @param paramMap
     */
    private void buildTaskCardDirectionTraceParameter(Map<String, Object> paramMap) {
        List<Integer> taskDirectionStates = MapUtil.get(paramMap, "direction", List.class);
        if (CollectionUtil.isEmpty(taskDirectionStates)) {
            return;
        }
        //2和3都属于退回，前端传2即可  后端搜索2和3状态信息
        boolean contains = taskDirectionStates.contains(2);
        if (contains) {
            taskDirectionStates.add(3);
        }
        paramMap.put("taskDirectionStates", taskDirectionStates);
    }

    /**
     * 构建项目卡来源条件
     *
     * @param paramMap
     */
    private void buildProjectCardSourceTraceParameter(Map<String, Object> paramMap) {
        List<Integer> projectSourceState = MapUtil.get(paramMap, "source", List.class);
        if (CollectionUtil.isEmpty(projectSourceState)) {
            return;
        }
        boolean b = projectSourceState.contains(10);
        if (b) {
            //前端取得枚举值以任务为准 10是任务交接 需要转换成项目交接3
            CollUtil.removeAny(projectSourceState, 10);
            projectSourceState.add(3);
        }
        paramMap.put("projectSourceState", projectSourceState);
    }
}
