package com.digiwin.athena.abt.application.service.atmc.migration.project;

import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityPageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmDataState;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmTaskDefineResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.commontype.CardPresentConfigQryService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.AglieService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BpmProcessMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmProcess;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 项目卡处理服务(新)
 */
@Slf4j
@Service
public class BpmCommonProjectHandleService {

    @Autowired
    private TaskMapper taskMapper;

    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private BpmProcessMapper bpmProcessMapper;

    @Autowired
    private CardPresentConfigQryService cardPresentConfigQryService;

    @Autowired
    private AglieService aglieService;


    /**
     * 获取项目卡本身的摘要信息，不获取其含有的任务摘要信息
     *
     * @param user
     * @param projectId
     * @return
     */
    public Map getProjectCardSelfAbstract(AuthoredUser user, long projectId, boolean needHistoryInfo) {

        Task task = taskMapper.selectById(projectId);
        if (task == null) {
            task = commonPtmTransformService.getTask(projectId);
        }
        Map<String, Object> map = new HashMap<>();
        if (task != null) {
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);

            setCheckSummaryForProjectCardAbstract(map, task, needHistoryInfo);
        }
        return map;
    }

    private void setCheckSummaryForProjectCardAbstract(Map<String, Object> map, Task task, boolean needHistoryInfo) {
        //默认未逾期，仅用于项目中控台
        map.put("overdue", false);

        String tmTaskId = (String) map.get("tmTaskId");
        long projectId = (long) map.get("projectId");

        TmTaskDefineResponseDTO themeMap = themeMapService.getTask(tmTaskId);
        if (themeMap == null || themeMap.getPages() == null) {
            return;
        }

        Map pages = themeMap.getPages();
        TmActivityPageDTO projectCardPage = null;
        if (pages.containsKey(TmPageName.PROJECT_CARD_NAME.getValue())) {
            String json = JsonUtils.objectToString(pages.get(TmPageName.PROJECT_CARD_NAME.getValue()));
            projectCardPage = JsonUtils.jsonToObject(json, TmActivityPageDTO.class);
        } else {
            return;
        }
        //xuxx 2022-11-01 所有的card也需要增加dataStates配置，如果同时存在，以dataStates里的为主
        if (CollectionUtils.isNotEmpty(projectCardPage.getDataStates())) {
            //默认先取第一个展示与uibot保持一致
            //TmDataState dataState = projectCardPage.getDataStates().get(0);
            TmDataState dataState = projectCardPage.getDataStateByDataStateType(Lists.newArrayList("summary", "businessInfo", "searchKey", "projectInfo"));
            if (CollectionUtils.isNotEmpty(dataState.getSummaryFields())) {
                projectCardPage.setSummaryFields(dataState.getSummaryFields());
            }
        }
        //兼容以前的逻辑，重构时可考虑合并；
        if (CollectionUtils.isEmpty(projectCardPage.getSummaryFields())) {
            //目前只支持summaryFields
            return;
        }

        Map activityData = getActivityData(task);
        activityData.put("needHistoryInfo", needHistoryInfo);

        BaseResultDTO<Map<String, Object>> actionResponse = aglieService.getProjectCardDataByProjectDataAbstract(tmTaskId, projectId, activityData);
        if (actionResponse == null || actionResponse.getResponse() == null) {
            return;
        }

        // 将 scheduleRefreshCardMessage 携带出该方法
        map.put("scheduleRefreshCardMessage", projectCardPage.getScheduleRefreshCardMessage());
        map.put("summaryLayout", actionResponse.getResponse().get("summaryLayoutStr"));
        map.put("historyMessage", actionResponse.getResponse().get("historyMessage"));
        map.put("searchMessage", actionResponse.getResponse().get("searchMessage"));

        //xuxx 2022-11-01 所有的card也需要增加dataStates配置，如果同时存在，以dataStates里的为主
        if (CollectionUtils.isNotEmpty(projectCardPage.getDataStates())) {
            //默认先取第一个展示与uibot保持一致
            //TmDataState dataState = projectCardPage.getDataStates().get(0);
            TmDataState dataState = projectCardPage.getDataStateByDataStateType(Lists.newArrayList("summary"));
            if (!StringUtils.isEmpty(dataState.getOverduePropertyName())) {
                projectCardPage.setOverduePropertyName(dataState.getOverduePropertyName());
            }
        }
        //兼容以前的逻辑，待旧配置迁移完后可考虑合并；
        //region PCC的项目逾期通过API的返回字段，修改卡片样式为逾期样式
        if (!StringUtils.isEmpty(projectCardPage.getOverduePropertyName())) {
            Map<String, Object> response = actionResponse.getResponse();
            if (response.containsKey("pageData") && response.get("pageData") != null && response.get("pageData") instanceof Map) {
                Map<String, Object> pageData = (Map<String, Object>) response.get("pageData");
                if (MapUtils.isNotEmpty(pageData) && pageData.containsKey(projectCardPage.getOverduePropertyName())) {
                    Object overdue = pageData.get(projectCardPage.getOverduePropertyName());
                    map.put("overdue", Objects.equals(overdue, 1.0));
                }
            }
        }

        // 设置卡面呈现配置
        cardPresentConfigQryService.setCardPresentConfigs(map, TmPageName.PROJECT_CARD_NAME.getValue());
        //endregion
    }

    public Map getActivityData(Task task) {
        Map project = new HashMap();
        project.put("projectId", task.getId());
        project.put("tmProjectId", task.getTmTaskId());
        project.put("chargeId", task.getPersonInCharge());
        project.put("chargeName", task.getPersonInChargeName());
        project.put("tenantId", task.getTenantId());
        project.put("startTime", task.getStartTime());
        project.put("endTime", task.getEndTime());
        project.put("projectName", task.getName());

        List<Map<String, Object>> tasks = new ArrayList<>();
        List<BpmProcess> processList = bpmProcessMapper.selectListByProjectId(task.getId());
        if (CollectionUtils.isEmpty(processList)) {
            //PTM
            processList = commonPtmTransformService.getProjectByProjectCardId(task.getId());
        }
        for (BpmProcess bpmProcess : processList) {
            Map<String, Object> taskObject = new HashMap<>();

            taskObject.put("processSerialNumber", bpmProcess.getProcessSerialNumber());
            taskObject.put("bpmData", bpmProcess.getData());
            taskObject.put("businessUnit", bpmProcess.getBusinessUnit());
            taskObject.put("proxyToken", bpmProcess.getProxyToken());

            tasks.add(taskObject);
        }

        Map activityData = new HashMap();
        activityData.put("project", project);
        activityData.put("tasks", tasks);

        return activityData;
    }
}
