package com.digiwin.athena.abt.application.service.atmc.migration.project;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.json.JSONUtil;

import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardConfigDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

import java.util.*;

import java.util.stream.Collectors;


@Slf4j
@Service
public class ProjectHandleService {

    @Autowired
    private ThemeMapService themeMapService;

    public void addDataFieldsV2(List<ProjectCardDTO> list, AuthoredUser user, String pageCode) {
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start("km rule v2 process time");
            cn.hutool.json.JSONObject param = new cn.hutool.json.JSONObject();
            param.putIfAbsent("pageCode", pageCode);
            Set<String> codes = new HashSet<>();
            codes.addAll(list.stream().map(ProjectCardDTO::getTmTaskId).collect(Collectors.toSet()));
            log.info(" process time v2 get km rule data :{}", param);
            if (codes.isEmpty()) {
                stopWatch.stop();
                return;
            }
            param.putIfAbsent("codes", codes);
            Map<String, Object> cardConfig = themeMapService.postCardConfigByType(param);
            stopWatch.stop();
            log.info("【cardConfig-data: {}】", cardConfig);
            list.forEach(e -> {
                Object o = cardConfig.get(e.getTmTaskId());
                if (o != null) {
                    Map<String, List> config = JSONUtil.toBean(JSONUtil.toJsonStr(o), new TypeReference<Map<String, List>>() {
                    }, true);
                    if (config != null) {
                        e.setCardConfig(JSONUtil.toList(JSONUtil.parseArray(config.get("config")), CardConfigDTO.class));
                    }
                    cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(JSONUtil.toJsonStr(cardConfig.get("businessMessageSourceMethodMap")));
                    e.setBusinessMessageSourceMethod(jsonObject.getStr(e.getTmTaskId()));
                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
