package com.digiwin.athena.abt.application.service.atmc.migration.ptm;


import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardItemDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCard;

import java.util.List;

/**
 * PTM 项目卡、项目 与其他转换服务
 * 用于查询PTM 项目卡、项目相关数据，且转换成需要的数据格式
 */
public interface PtmProjectTransformService {


    /**
     * MQTT专用。<br>根据项目卡id 获取 ProjectCardDTO
     * @param projectCard
     * @return 没有返回null
     */
    ProjectCardDTO translateProjectCardForMQTT(PtmProjectCard projectCard, String autherUserId);

    /**
     * 处理项目卡信息
     */
    List<ProjectCardDTO> setProjectCardList(List<PtmProjectCard> projectCardList, List<PtmProjectCardItemDTO> ptmProjectCardList);

}
