package com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie;

import com.digiwin.athena.abt.application.dto.migration.atmc.agile.CardDataParam;
import com.digiwin.athena.appcore.domain.BaseResultDTO;

import java.util.HashMap;
import java.util.Map;

public interface AglieService {

    /**
     * 获取任务卡 拼接字符等数
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param backlogId
     * @return
     */
    BaseResultDTO<Map> getTaskCardAbstractStr(String tmTaskId, String tmActivityId, Long backlogId, Object activityDataDTO,Integer count,String langName);


    /**
     * 获取任务的数据大小
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param activityDataDTO
     * @return
     */
    BaseResultDTO<HashMap> getTaskCardDataSize(String tmTaskId, String tmActivityId, Object activityDataDTO);

    /**
     * 获取卡面业务数据
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param activityDataDTO
     * @return
     */
    BaseResultDTO<Map<String,Object>> getCardBusinessMessage(String tmTaskId, String tmActivityId, Object activityDataDTO);

    /**
     * 获取项目卡CheckItems等数,根据据项目自身的数据，不依赖任务（字符串）
     *
     * @param tmTaskId
     * @param projectId
     * @return
     */
    BaseResultDTO<Map<String, Object>> getProjectCardDataByProjectDataAbstract(String tmTaskId, Long projectId, Object activityDataDTO);

    /**
     * 获取卡面业务数据
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param cardDataParam
     * @return
     */
    BaseResultDTO<Map<String,Map<Long, Map<Long,Map<String, Object>>>>> getBatchCardBusinessMessage(String tmTaskId, String tmActivityId, CardDataParam cardDataParam);

    BaseResultDTO<Map> getTaskCardAbstractStrBatch(String tmTaskId, String tmActivityId, String bks, Object activityDataDTO);

}

