package com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.agile.CardDataParam;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.AglieService;
import com.digiwin.athena.abt.application.utils.AtmcStrUtil;
import com.digiwin.athena.abt.core.meta.constants.UibotApiConstant;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.jugg.agile.biz.digiwin.config.biz.DwBizConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class AglieServiceImpl implements AglieService {

    @Autowired
    RestTemplate restTemplate;

    /**
     * 获取任务卡 拼接字符等数
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param backlogId
     * @return
     */
    @Override
    public BaseResultDTO<Map> getTaskCardAbstractStr(String tmTaskId, String tmActivityId, Long backlogId, Object activityDataDTO, Integer count, String langName) {
        return getTaskCardLayoutAbstract(tmTaskId, tmActivityId, backlogId, activityDataDTO, null, count, langName);
    }

    public BaseResultDTO<Map> getTaskCardLayoutAbstract(String tmTaskId, String tmActivityId, Long backlogId,
                                                        Object activityDataDTO, String flag, Integer count, String langName) {
        String url = getUibotUri() + AtmcStrUtil.format(UibotApiConstant.TASK_CARD_ABSTRACT_TM_TASK_ID_TM_ACTIVITY_ID_BACKLOG_ID, tmTaskId, tmActivityId, backlogId);

        url = url + "?count=" + (count == null ? 0 : count);
        if (StringUtils.isNotEmpty(flag)) {
            url = url + "&flag=" + flag;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (StringUtils.isNotEmpty(langName)) {
            headers.add("locale", langName);
        } else {
            addLang(headers);
        }

        Map<String, String> param = new HashMap<>();

        HttpEntity httpEntity = new HttpEntity(activityDataDTO, headers);
        ResponseEntity<BaseResultDTO<Map>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<Map>>() {
                }, param);
        return responseEntity.getBody();
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }


    /**
     * 获取任务卡CheckItems等数
     *
     * @param tmTaskId
     * @param tmActivityId
     * @return
     */
    @Override
    public BaseResultDTO<HashMap> getTaskCardDataSize(String tmTaskId, String tmActivityId, Object activityDataDTO) {
        String url = getUibotUri() + AtmcStrUtil.format(UibotApiConstant.TASK_TM_TASK_ID_TM_ACTIVITY_ID_DATA_SIZE, tmTaskId, tmActivityId);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();

        HttpEntity httpEntity = new HttpEntity(activityDataDTO, headers);
        ResponseEntity<BaseResultDTO<HashMap>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<HashMap>>() {
                }, param);

        return responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map<String, Object>> getCardBusinessMessage(String tmTaskId, String tmActivityId, Object activityDataDTO) {
        String url = getUibotUri();
        if (StringUtils.isBlank(tmActivityId)) {
            url += AtmcStrUtil.format(UibotApiConstant.CARD_BUSINESS_MESSAGE2, tmTaskId);
        } else {
            url += AtmcStrUtil.format(UibotApiConstant.CARD_BUSINESS_MESSAGE, tmTaskId, tmActivityId);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);
        headers.add("security-token", null);
        Map<String, Object> param = new HashMap<>();
        param.put("flag", false);
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, headers);
        ResponseEntity<BaseResultDTO<Map<String, Object>>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                }, param);
        return responseEntity.getBody();
    }

    /**
     * 项目卡摘要信息，不依赖任务（字符串）
     *
     * @Author：SYQ
     * @Date：2021/12/30 10:35
     */
    @Override
    public BaseResultDTO<Map<String, Object>> getProjectCardDataByProjectDataAbstract(String tmTaskId, Long projectId, Object activityDataDTO) {
        String url = getUibotUri() + AtmcStrUtil.format(UibotApiConstant.PROJECT_CARD_ABSTRACT_TM_TASK_ID_PROJECT_ID, tmTaskId, projectId);
        return getCardData(url, activityDataDTO);
    }

    private String getUibotUri() {
        return DwBizConfig.AaskDomainConfig.Sai.getUibotUri();
    }

    private BaseResultDTO<Map<String, Object>> getCardData(String uri, Object activityDataDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, headers);
        ResponseEntity<BaseResultDTO<Map<String, Object>>> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
        }, param);
        responseEntity.getBody().getResponseWithException("");
        return responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map<String, Map<Long, Map<Long, Map<String, Object>>>>> getBatchCardBusinessMessage(String tmTaskId, String tmActivityId, CardDataParam cardDataParam) {
        String url = getUibotUri();
        if (StringUtils.isBlank(tmActivityId)) {
            url += UibotApiConstant.CARD_BATCH_BUSINESS_URL + "/" + tmTaskId;
        } else {
            url += UibotApiConstant.CARD_BATCH_BUSINESS_URL + "/" + tmTaskId + "/" + tmActivityId;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);
        headers.add("security-token", null);
        HttpEntity httpEntity = new HttpEntity(cardDataParam, headers);
        ResponseEntity<BaseResultDTO<Map<String, Map<Long, Map<Long, Map<String, Object>>>>>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<Map<String, Map<Long, Map<Long, Map<String, Object>>>>>>() {
                });

        return responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map> getTaskCardAbstractStrBatch(String tmTaskId, String tmActivityId, String bks, Object activityDataDTO) {
        return getTaskCardLayoutAbstractBatch(tmTaskId,tmActivityId,bks,activityDataDTO,null);
    }

    private BaseResultDTO<Map> getTaskCardLayoutAbstractBatch(String tmTaskId, String tmActivityId, String bkContact,
                                                              Object activityDataDTO, String flag) {
        String url = getUibotUri() + AtmcStrUtil.format(UibotApiConstant.TASK_CARD_ABSTRACT_TM_TASK_ID_TM_ACTIVITY_ID, tmTaskId, tmActivityId, bkContact);

        if (StringUtils.isNotEmpty(flag)) {
            url = url + "?flag=" + flag;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();


        HttpEntity httpEntity = new HttpEntity(activityDataDTO, headers);
        ResponseEntity<BaseResultDTO<Map>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<Map>>() {
                }, param);
        return responseEntity.getBody();
    }
}
