package com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim;

import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.AimEventDO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.springframework.http.ResponseEntity;

import java.util.List;
import java.util.Map;

/**
 * 对接Aim服务
 *
 * @author majfa
 * @since [迭代13]
 */
public interface AimService {

    void message(AuthoredUser authoredUser, MessageDO message);

    /**
     * 发送消息提醒
     *
     * @Author：SYQ
     * @Date：2022/4/11 15:08
     */
    void sendMsgRemindToClient(String token, String tenantId, String userId, AppMessageDTO appMessageDTO);

    /**
     * 发送催办事件通知
     */
    void sendUrageDealNotice(AuthoredUser user, AimEventDO event);

    /**
     * 发送消息给在线客户端
     */
    void sendMessageToClient(String token, String tenantId, List<String> userIdList, MessageDO message);

    /**
     * 消息中心根据配置发送消息
     * @param tenantId
     * @param appCode
     * @param data
     */
    void sendMsg4AllChannel(String token, String tenantId, String appCode, String sceneId,  Map<String, Object> data);


    /**
     * App 消息推波
     * @param authoredUser
     * @param message
     */
    void sendToAppClient(AuthoredUser authoredUser, MessageDO message);

}
