package com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.AimEventDO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageBatchUserDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.abt.core.meta.constants.AimApiConstant;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class AimServiceImpl implements AimService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;


    @Override
    public void message(AuthoredUser authoredUser, MessageDO message) {
        LogDto logDto = new LogDto("请求aim存储新消息开始，参数： " + JsonUtils.objectToString(message), message.getTenantId());
        log.info(logDto.toString());

        String url = envProperties.getAimUri() + AimApiConstant.MESSAGE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, authoredUser.getToken());
        HttpEntity httpEntity = new HttpEntity(message, headers);
        try {
            ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO>() {
                    });
            if (respEntity.getStatusCode().value() != org.apache.http.HttpStatus.SC_OK || !respEntity.getBody().isOK()) {
                log.error("请求aim存储新消息失败，statusCode: {}, responseBody: {}.", respEntity.getStatusCode().value(), respEntity.getBody());
            }
        } catch (Exception ex) {
            LogDto logDtoError = new LogDto("请求aim存储新消息失败: " , message.getTenantId());
            log.error(logDtoError.toString());
            log.error("请求aim存储新消息失败，error: {}.", ex);
        }
    }

    @Override
    public void sendMsgRemindToClient(String token, String tenantId, String userId, AppMessageDTO appMessageDTO) {
        LogDto logDto = new LogDto("请求aim发送新消息开始，url：" + appMessageDTO.getDetailUrl(), tenantId + appMessageDTO.getDetailUrl());
        log.info(logDto.toString());
        // 初始化消息创建时间
        initMsgCreateTime(appMessageDTO);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        HttpEntity<?> httpEntity = new HttpEntity<>(appMessageDTO, headers);
        String url = envProperties.getAimUri() + AimApiConstant.SEND_MESSAGE_REMIND_TO_CLIENT;
        log.info("【请求aim发送新消息入参开始】：url：{}，tenantId：{}，userId：{}，appMessageDTO：{}", url, tenantId, userId, appMessageDTO);
        ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
        });
        log.info("【请求aim发送新消息入参结果：{}】", responseEntity);
        responseEntity.getBody().getResponseWithException("");
    }

    /**
     * 初始化消息创建时间
     *
     * @param appMessageDTO
     * @author majianfu
     * @since [迭代13 消息通知弹窗增加已通知时间]
     */
    private void initMsgCreateTime(AppMessageDTO appMessageDTO) {
        if (null == appMessageDTO) {
            return;
        }

        Object msgContent = appMessageDTO.getContent();
        if (null == msgContent) {
            appMessageDTO.setContent(new HashMap<String, Object>());
            msgContent = appMessageDTO.getContent();
        }

        if (msgContent instanceof Map) {
            Map<String, Object> msgContentMap = (Map<String, Object>) msgContent;
            msgContentMap.put("msgCreateTime", System.currentTimeMillis());
        }
    }

    /**
     * 发送催办事件通知
     *
     * @param user
     * @param event
     */
    @Override
    public void sendUrageDealNotice(AuthoredUser user, AimEventDO event) {
        log.info("sendUrageDealNotice-user:{},event:{}", JsonUtils.objectToString(user), JsonUtils.objectToString(event));
        String url = envProperties.getAimUri() + AimApiConstant.EVENT_MQ_SEND_URGE_DEAL_EVENT;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());

        HttpEntity httpEntity = new HttpEntity(event, headers);
        try {
            ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            if (respEntity.getStatusCode().value() != org.apache.http.HttpStatus.SC_OK || !respEntity.getBody().isOK()) {
                log.error("Failed to request aim to send reminder event ，statusCode: {}, responseBody: {}.", respEntity.getStatusCode().value(), respEntity.getBody());
            }
        } catch (Exception ex) {
            log.error("Failed to request aim to send reminder event，error: {}.", ex);
        }
    }

    /**
     * @param message 内容
     */
    @Override
    public void sendMessageToClient(String token, String tenantId, List<String> userIdList, MessageDO message) {
        LogDto logDto = new LogDto("请求aim发送新消息开始，userIds：" + userIdList, tenantId + userIdList.toString());
        log.info(logDto.toString());
        MessageBatchUserDTO messageBatchUserDTO = new MessageBatchUserDTO();
        messageBatchUserDTO.setMessage(message);
        messageBatchUserDTO.setUserIdList(userIdList);
        messageBatchUserDTO.setTenantId(tenantId);

        String url = envProperties.getAimUri() + AimApiConstant.SEND_MESSAGE_TO_CLIENT;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);

        HttpEntity httpEntity = new HttpEntity(messageBatchUserDTO, headers);
        ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO>() {
                });
        respEntity.getBody().getResponseWithException("");
    }

    @Override
    public void sendMsg4AllChannel(String token, String tenantId, String appCode, String sceneId, Map<String, Object> data) {
        log.info("[sendMsg4AllChannel] start tenantId = {},appCode = {},data = {}",tenantId,appCode,JsonUtils.objectToString(data));

        Map<String, Object> params = new HashMap<>();
        params.put("tenantId", tenantId);
        params.put("appCode", appCode);
        params.put("sceneId", sceneId);
        params.put("data", data);
        String url = envProperties.getAimUri() + AimApiConstant.MESSAGE_CENTEER_SEND_MSG;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);

        HttpEntity httpEntity = new HttpEntity(params, headers);
        ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO>() {
                });
        respEntity.getBody().getResponseWithException("");
    }

    @Override
    public void sendToAppClient(AuthoredUser authoredUser, MessageDO message) {

        log.info("[sendToAppClient] start message = {}",JsonUtils.objectToString(message));

        String url = envProperties.getAimUri() + AimApiConstant.SEND_MESSAGE_REMIND_TO_APP_CLIENT;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, authoredUser.getToken());
        HttpEntity httpEntity = new HttpEntity(message, headers);
        try {
            ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO>() {
                    });
            if (respEntity.getStatusCode().value() != org.apache.http.HttpStatus.SC_OK || !respEntity.getBody().isOK()) {
                log.error("[sendToAppClient] 发送App 消息推波 失败 ，statusCode: {}, responseBody: {}", respEntity.getStatusCode().value(), respEntity.getBody());
            }
        } catch (Exception ex) {
            log.error("[sendToAppClient]发送App 消息推波 失败", ex);
        }

    }

}
