package com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.TenantService;
import com.digiwin.athena.abt.core.meta.constants.IamApiConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class TenantServiceImpl implements TenantService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;


    /**
     * 从api中获取租户的虚拟token
     *
     * @param tenantId 租户id
     * @return token信息
     */
    @Override
    public JSONObject queryApiVirtualToken(String tenantId) {
        //查询租户虚拟tokenUrl
        String uri = envProperties.getIamUri() + IamApiConstant.IDENTITY_LOGIN_INTERNAL;

        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String, String> param = new HashMap<>();
        param.put("tenantId", tenantId);
        param.put("userId", "integration");
        param.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        ResponseEntity<JSONObject> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<JSONObject>() {
                }, param);


        JSONObject result = responseEntity.getBody();
        if (null == result) {
            log.error("this tenant :{}return none virtual token.", tenantId);
            return new JSONObject();
        }
        return result;
    }

}
