package com.digiwin.athena.abt.application.service.atmc.migration.restfull.dataFootPrint.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.dataFootPrint.DataFootPrintService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xuwx
 * @date 2024/12/18
 * @Description 数据足迹接口调用
 */
@Service
@Slf4j
public class DataFootPrintServiceImpl implements DataFootPrintService {
    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Override
    public List<Map<String,Object>> queryByBk(String tenantId, JSONObject bkInfo) {
        List<Map<String,Object>> list = null;
        String url = this.envProperties.getSdDataFootPrintUrl() + "restful/service/DataFootprint/activity/queryByBk";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        this.addLang(headers);
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("bkInfo", bkInfo);
        rootPara.put("tenantId", tenantId);
        HttpEntity<?> httpEntity = new HttpEntity(rootPara, headers);
        ResponseEntity<BaseResultDTO<List<Map<String,Object>>>> responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<Map<String,Object>>>>() {
        }, rootPara);
        list = (responseEntity.getBody()).getResponseWithException("");

        if (list == null) {
            return new ArrayList();
        }
        return list;
    }
    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }
}
