package com.digiwin.athena.abt.application.service.atmc.migration.restfull.emc.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.emc.EmcService;
import com.digiwin.athena.iam.sdk.meta.dto.IamResultDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
public class EmcServiceImpl implements EmcService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Override
    public List<Map<String, Object>> getWecomConfig() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //组装请求体
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(null, headers);
        String url = envProperties.getEmcUri() + "/api/emc/v1/appconfig/outsource/current";
        ResponseEntity<IamResultDTO<List<Map<String, Object>>>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                new ParameterizedTypeReference<IamResultDTO<List<Map<String, Object>>>>() {
                });
        if (null != respEntity.getBody() && 200 == respEntity.getBody().getCode()) {
            return respEntity.getBody().data();
        }
        return new ArrayList<>();
    }

}


