package com.digiwin.athena.abt.application.service.atmc.migration.restfull.emc.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.EmailWithTemplateMsgDO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.emc.SendEmailService;
import com.digiwin.athena.abt.core.meta.constants.EmcApiConstant;
import com.digiwin.athena.abt.core.meta.enums.AtmcErrorCodeEnum;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class SendEmailServiceImpl implements SendEmailService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;


    @Override
    public void sendEmail(JSONObject content) {
        AuthoredUser authoredUser = getContextAuthoredUser();
        log.info("[SendEmail] SendEmailService start: {}", content);
        log.info("[SendEmail] userId: {}, tenantId: {}, token: {}", authoredUser.getUserId(), authoredUser.getTenantId(), authoredUser.getToken());

        String url = envProperties.getEmcUri() + EmcApiConstant.SEND_EMAIL_URL;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(content, headers);

        ResponseEntity<HashMap> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class);
        Object code = respEntity.getBody().get("code");
        Object success = respEntity.getBody().get("success");
        try {
            if (!requestSuccess(code, success)) {
                log.error("{}, 调用emc发送邮件失败，{}, {}", AtmcErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getErrCode(), AtmcErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getErrMsg(), "status code: " + HttpStatus.SC_OK + ", code: " + code + ", message: " + JsonUtils.objectToString(respEntity.getBody().get("message")));
                throw AtmcErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getBusinessException();
            }
        } catch (Exception ex) {
            throw ExceptionUtil.wrap(AtmcErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getErrCode(), ex);
        }
    }


    private AuthoredUser getContextAuthoredUser() {
        if (null != AppAuthContextHolder.getContext().getAuthoredUser()) {
            return AppAuthContextHolder.getContext().getAuthoredUser();
        } else {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void sendEmailWithTemplate(String templateId, String contacts, Map emailData, MessageDO message) {
        EmailWithTemplateMsgDO msgDO = new EmailWithTemplateMsgDO();
        msgDO.setTemplateId(templateId);
        msgDO.setContacts(contacts);
        JSONObject emailMsg = new JSONObject();
        emailMsg.put("data", emailData);
        msgDO.setMessage(emailMsg);
        if (ObjectUtils.isNotEmpty(message) && !StringUtils.isEmpty(message.getFileId())) {
            msgDO.setFileIds(Collections.singletonList(message.getFileId()));
            msgDO.setDmcBucket(message.getDmcBucket());
        }
        sendEmailWithTemplate(msgDO);
    }

    @Override
    public void sendEmailWithTemplate(EmailWithTemplateMsgDO msgDO) {
        JSONObject emailJson = new JSONObject();
        emailJson.put("eventId", msgDO.getTemplateId());
        emailJson.put("message", msgDO.getMessage());
        emailJson.put("contacts", msgDO.getContacts());
        if (!CollectionUtils.isEmpty(msgDO.getFileIds())) {
            emailJson.put("dmcAttachments", msgDO.getFileIds());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty(msgDO.getDmcBucket())) {
            emailJson.put("dmcBucket", msgDO.getDmcBucket());
        }
        log.info("[sendEmailWithTemplate emailJson]:{}", emailJson);
        LogDto logDto = new LogDto("开始发送邮件，模板id:{}", msgDO.getTemplateId());
        log.info(logDto.toString());
        sendEmail(emailJson);
    }

    private boolean requestSuccess(Object code, Object success) {
        if (null == code || null == success) {
            return false;
        }
        return org.apache.commons.lang3.StringUtils.equals(String.valueOf(code), String.valueOf(HttpStatus.SC_OK)) && Boolean.valueOf(String.valueOf(success));
    }
}
