package com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc;

import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface EocService {

    /**
     * 获取指定用户的代理用户
     *
     * @param userId 用户id
     * @return 用户基本信息
     */
    ProxyUserResp getProxyUser(String userId, String token);

    /**
     * 获取EOC用户信息
     *
     * @Author：SYQ
     * @Date：2021/6/15 17:07
     */
    String getEocEmpInfo(String userId, AuthoredUser user);

    /**
     * 根据租户Sid和用户id获取EOC员工信息
     *
     * @Author：SYQ
     * @Date：2021/7/5 16:44
     */
    String getEocByTenantAndUser(AuthoredUser user, String tenantSid, String userId);

}
