package com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.EocEmployeeDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.EocResultDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.abt.application.dto.migration.atmc.iam.ProxyUserDTOWithCodeResp;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.core.meta.constants.EocApiConstant;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Slf4j
@Service
public class EocServiceImpl implements EocService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Override
    public ProxyUserResp getProxyUser(String userId, String token) {
        //获取员工ID
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        //post body
        Map<String, String> param = new HashMap<>();
        param.put("userId", userId);
        param.put("agentDate", df.format(LocalDateTime.now()));
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        String url = envProperties.getEocUri() + EocApiConstant.EMP_AGENT;
        ResponseEntity<ProxyUserDTOWithCodeResp> responseEntity = restTemplate.postForEntity(url, httpEntity, ProxyUserDTOWithCodeResp.class);
        ProxyUserDTOWithCodeResp baseResult = responseEntity.getBody();
        if (baseResult.getCode() == 200 && baseResult.getData() != null) {
            return baseResult.getData();
        }
        return null;
    }

    /**
     * 获取EOC用户信息
     *
     * @Author：SYQ
     * @Date：2021/6/15 17:07
     */
    @Override
    public String getEocEmpInfo(String userId, AuthoredUser user) {
        String eocEmpId = "";

        EocEmployeeDTO employee = getEmployee(userId, null);
        if (Objects.isNull(employee)){
            return eocEmpId;
        }
        return employee.getId();
    }

    private EocEmployeeDTO getEmployee(String userId, String empId) {
        String uri = envProperties.getEocUri() + EocApiConstant.EMP_INFO;

        HttpHeaders headers = getHeaders();
        addLang(headers);

        Map<String, Object> param = new HashMap<>();
        param.put("userId", userId);
        param.put("empId", empId);
        param.put("showException",false);
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        try {
            ResponseEntity<EocResultDTO> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap<>());
            EocResultDTO result = responseEntity.getBody();
            if (result != null) {
                if(result.isSuccess()) {
                    return JsonUtils.jsonToObject(JSONObject.fromObject(result.getData()).toString(), EocEmployeeDTO.class);
                }
                else {
                    log.warn(result.getMessage());
                }
            }
        } catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
        return null;
    }

    /**
     * 根据租户Sid和用户id获取EOC员工信息
     *
     * @Author：SYQ
     * @Date：2021/7/5 16:44
     */
    @Override
    public String getEocByTenantAndUser(AuthoredUser user, String tenantSid, String userId) {
        if (org.apache.commons.lang.StringUtils.isEmpty(tenantSid) || org.apache.commons.lang.StringUtils.isEmpty(userId)) {
            return "";
        }
        String eocUserId = "";
        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        //获取当前用户是否开启代理以及代理人地址
        String url = envProperties.getEocUri() + EocApiConstant.EMP_TENANT_USER_ID_INFO;
        //查询参数
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("tenantSid", tenantSid);
        paramMap.put("userId", userId);
        HttpEntity<?> httpEntity = new HttpEntity<>(paramMap, headers);
        //获取当前用户是否开启代理以及代理人
        try {
            ResponseEntity<Map> response = restTemplate.postForEntity(url, httpEntity, Map.class);
            //判断API是否调用成功
            if (response.getStatusCode() == HttpStatus.OK) {
                //获取data数据
                JSONObject jsonObject = JSONObject.fromObject(response.getBody().get("data"));
                //获取eoc员工id
                eocUserId = jsonObject.getString("id");
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        return eocUserId;
    }


    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }


}
