package com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam;

import com.digiwin.athena.abt.application.dto.migration.atmc.iam.UserDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.usersetting.PersonalizedDto;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;

public interface UserService {
    /**
     * 根据用户id获取用户相关的信息
     *
     * @param userId 用户id
     * @param token  合法的token
     * @return 用户基本信息
     */
    UserDTO query(String userId, String token);

    /**
     * 根据用户id获取用户相关的信息
     *
     * @param userId 用户id
     * @return 用户基本信息
     */
    UserDTO query(String userId);

    /**
     * 获取目标用户：优先取当前用户的代理用户，否则返回当前用户
     *
     * @param userId
     * @param token
     * @return
     */
    UserDTO getTargetUser(String userId, String token);


    /**
     * 根据userSid获取租户语言别设置
     *
     * @param userId
     * @param token
     * @return
     */
    String getUserLangMetadataAllTenant(String userId, String token);

    /**
     * 通过用户ID 获取是否静默
     *
     * @param userId
     * @param token
     * @return
     */
    boolean getMessageDoNotDisturbUserId(String userId, String tenantId, String token);

    /**
     * 根据用户id查询出用户的
     *
     * @param userId 用户id
     * @return email
     */
    String queryUserEmail(String userId);

    /**
     * 查询用户的个性化设置数据
     *
     * @param tenantSid 租户SID，注意非租户id
     * @param userId    用户id
     * @param key       需要查询的key
     * @param catalogId 类目id
     * @return PersonalizedDto
     */
    PersonalizedDto queryPersonalizedInfo(Long tenantSid, String userId, String key, String catalogId);

    /**
     * 获取内部员工
     *
     * @Author：SYQ
     * @Date：2021/6/15 14:42
     */
    List<String> getEmployee(List<String> userList, AuthoredUser user);

    /**
     * 通过用户ID 获取员工的多语言
     *
     * @param userId
     * @param token
     * @return
     */
    String getUserLangNameByUserId(String userId, String tenantId, String token);

}

