package com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.IamService;
import com.digiwin.athena.abt.core.meta.constants.IamApiConstant;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

@Service
@Slf4j
public class IamServiceImpl implements IamService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Override
    public String getTenantCorpid() {

        // header信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add(GlobalConstant.IAM_APP_TOKEN, com.digiwin.athena.appcore.auth.GlobalConstant.IAM_APP_TOKEN_ATHENA);

        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(null, headers);
        String url = envProperties.getIamUri() + IamApiConstant.USER_TENANT_CORPID;
        try {
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity, JSONObject.class);
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody() != null && respEntity.getBody().containsKey("data")) {
                return respEntity.getBody().getString("data");
            }
        } catch (Exception ex) {
            log.error("从IAM获取当前登入租户的corpId异常, errorMsg:{}", ex.getMessage());
        }
        return "";
    }
}
