package com.digiwin.athena.abt.application.service.atmc.migration.restfull.im;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;
import java.util.Map;

/**
 * ImService Description
 *
 * @author majianfu
 * @date 2021/7/10
 * @since
 */
public interface ImService {

    /**
     * 关闭群（用于atmc）
     * @Author：SYQ
     * @Date：2021/6/16 11:13
     */
    void removeTeam(String bizId, int type, AuthoredUser user);

    /**
     * 修改群信息
     * @Author：SYQ
     * @Date：2021/10/25 15:28
     */
    void updateTeamInfo(AuthoredUser user,String tid,String cardIds);

    /**
     * 获取群信息
     * @Author：SYQ
     * @Date：2021/10/25 15:28
     */
    Map getTeamInfo(AuthoredUser user,String bizId,int type,String source);

    /**
     * 批量解散群(用于pcc)
     * @Author：SYQ
     * @Date：2021/11/1 17:54
     */
    void removeTeamByParam(String bizId,int type,String cardId,String businessKey,AuthoredUser user);

    /**
     * 创建群
     * @Author：SYQ
     * @Date：2021/6/10 17:14
     */
    void createTeam(AuthoredUser user, String owner, String teamName, String bizId, int type,
                    int ifMaster, int visiable, List<String> memberList, String pId,
                    List<Map> externalAccounts, List<Map> externalEocMembers, String businessKey);

    /**
     * 添加群成员
     * @Author：SYQ
     * @Date：2021/6/10 17:20
     */
    void addTeamMembers(AuthoredUser user,String bizId,int type,List<String> memberList);
}
