package com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm;

import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.*;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.*;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmAgentPerformerDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCardITraceDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmTaskCardITraceDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.ReassignTrace;

import java.util.List;
import java.util.Map;

/**
 * PTM 服务
 */
public interface PtmService {

    /**
     * 获取项目记录详情(ptm_project表)
     *
     * @param projectId
     * @return
     */
    PtmProjectRecordBO getProjectRecord(Long projectId);

    /**
     * 获取任务记录详情(ptm_task表)
     *
     * @param taskId
     * @return
     */
    PtmTaskRecordBO getTaskRecord(Long taskId,Long workItemId);

    /**
     * 获取活动记录详情(ptm_activity表)
     *
     * @param activityId
     * @return
     */
    PtmActivityRecordDTO getActivityRecord(Long activityId);

    /**
     * 获取待办的记录详情(ptm_backlog 表记录)
     *
     * @param backlogId
     * @return
     */
    PtmBacklogRecordDTO getBacklogRecord(Long backlogId);

    /**
     * 获取事项的记录详情(ptm_task_activity_item 表记录)
     *
     * @param workItemId
     * @return
     */
    PtmWorkItemRecordBO getWorkItemRecord(Long workItemId);

    /**
     * 根据backlogId获取全部中的任务列表
     *
     * @param backlogId 待办id
     * @return
     */
    List<PtmBacklogItemBO> getBacklogByBacklogId(Long backlogId);

    /**
     * 获取项目卡记录详情（ptm_project_card表）
     *
     * @param projectCardId
     * @return
     */
    PtmProjectCardRecordDTO getProjectCardRecord(Long projectCardId);

    /**
     * 获取 项目 的路线列表
     *
     * @param projectId
     * @return
     */
    PtmProjectCardRouteDTO getProjectRoute(Long projectId);

    /**
     * 根据待办id获取任务卡的data、stateData
     *
     * @param backlogId ptm_backlog.id
     * @param type      非必填，传data，只返回data节点；传dataState，只返回dataState节点；不传都返回，后续异常排除任务卡查询数据可复用
     * @return data 取的是ptm.activity 的 data
     */
    List<PtmTaskCardDataDTO> getTaskDataByBacklogId(Long backlogId, String type);

    List<PtmTaskRecordBO> getTaskRecordByTaskIds(List<Long> taskIds);

    List<PtmActivityRecordDTO> getActivityRecordByActivityIds(List<Long> activityIds);


    /**
     * 批量-获取项目 记录详情(ptm_project表)
     * 警告：使用次方法前请确认是否需要项目列表中的data，如果不需要，请使用getProjectRecordByProjectIdsV2替代，需要data会消耗ptm较多内存
     *
     * @param projectIds
     * @return 没有值慢返回空集合
     */
    List<PtmProjectRecordBO> getProjectRecordByProjectIds(List<Long> projectIds);

    /**
     * 批量-获取项目 记录详情(ptm_project表)
     *
     * @param projectIds
     * @param needData   是否需要data数据，默认为需要
     * @return 没有值慢返回空集合
     */
    List<PtmProjectRecordBO> getProjectRecordByProjectIdsV2(List<Long> projectIds, boolean needData);

    /**
     * 批量 获取事项 的记录详情(ptm_task_activity_item 表记录)
     *
     * @param workItemIds
     * @return 没有值慢返回空集合
     */
    List<PtmWorkItemRecordBO> getWorkItemRecordByWorkItemIds(List<Long> workItemIds);


    /**
     * 根据异常排除待办id获取新发起项目的 所有的任务列表
     *
     * @param backlogId 待办id
     * @return
     */
    List<PtmSolveTask> getSolveTaskListV2(Long backlogId);

    /**
     * 根据backlogId获取全部中的任务列表（批量）
     *
     * @Author：SYQ
     * @Date：2022/6/16 15:52
     */
    List<PtmBacklogItemBO> getBacklogByBacklogIds(List<Long> backlogIdList);

    /**
     * 获取指定工作项 被发起退回重签或重办的 工作项，可能为null
     *
     * @param type             0 或 null，同一个任务，指签核任务内；1-不是同一个任务
     * @param workItemId
     * @param approvalTaskCode 要查询的签核任务code
     * @return 可能为null
     */
    PtmWorkItemRecordBO getReExecuteWorkItem(Integer type, Long workItemId, String approvalTaskCode);

    /**
     * 根据异常排除待办id获取新发起项目的 所有的任务列表
     *
     * @param originalBacklogIds
     * @return
     */
    List<Map> getSolveTaskList(List<Long> originalBacklogIds);

    /**
     * 获取 项目卡 详情
     *
     * @param projectCardId
     * @return
     */
    PtmProjectCardDetailDTO getProjectCardDetail(Long projectCardId);

    /**
     * 根据任务编码查询ptm待处理任务卡列表
     *
     * @param codes
     * @return
     */
    List<PtmTaskCardItemBO> queryTaskCardListByCodes(List<String> codes);

    /**
     * 查询ptm项目卡列表返回code和id
     *
     * @param codes 项目编码
     * @return List
     */
    List<PtmProjectCardItemDTO> queryProjectCardListByCodes(List<String> codes);

    /**
     * 查询事项的转派或者交接记录
     *
     * @return
     */
    List<ReassignTrace> selectReassignOrHandoverTrace(String workItemId, Integer type);

    /**
     * 批量 获取待办的记录详情(ptm_backlog 表记录)
     *
     * @param backlogIds
     * @return
     */
    List<PtmBacklogRecordDTO> getBacklogRecordByBacklogIds(List<Long> backlogIds);

    List<PtmTaskCardDataDTO> getTaskDataByBacklogIds(List<Map<String, Object>> backlogIds, String type, String isAllQuery);


    /**
     * 查询常规卡片所对应的辅助执行人，跨租户的卡片backlogId
     */
    List<PtmSpecialBacklogDTO> getSpecialBacklog(List<Long> workItemIds);

    /**
     * 获取指定工作项 被发起退回重签或重办的 工作项，可能为null
     * @param type 0 或 null，同一个任务，指签核任务内；1-不是同一个任务
     * @param backlogId
     * @param approvalTaskCode 要查询的签核任务code
     * @return 可能为null
     */
    Map<Long, TaskActivityItemVO> getReExecuteWorkItemByBacklogId(Integer type, Long backlogId, String approvalTaskCode);

    /**
     * 根据 项目卡Id 查询ptm项目卡列表
     * @param projectCardIdList 要查询的项目卡id
     * @return 没有值则返回空 List
     */
    List<PtmProjectCardItemDTO> queryProjectCardListByProjectCardId(List<Long> projectCardIdList,String userId);

    /**
     * 批量-获取指定项目卡中最近一次项目记录<br>
     * 不含data数据
     * @param projectCardIds
     * @return
     */
    List<PtmProjectRecordBO> getLastProjectRecordByProjectCardIds(List<Long> projectCardIds);

    /**
     * 处理数据 查询项目卡卡片状态/来源/去向
     * @param list
     * @param userId
     * @return
     */
    List<PtmProjectCardITraceDTO> queryProjectCardTrace(List<Long> list, String userId);

    /**
     * 处理数据 查询任务卡卡片状态/来源/去向
     * @param taskCards
     * @param userId
     * @return
     */
    List<PtmTaskCardITraceDTO> queryTaskCardTrace(List<Long> taskCards, String userId);

    /**
     * 获取任务卡待办id集合
     *
     * @param ids  任务或项目 id集合
     * @param code 任务或项目code
     * @param type 任务或项目 (task/project)
     * @return 待办id列表
     */
    List<Map<String,String>> queryBacklogIds(List<Long> ids, String type, String code);

    /**
     * 获取已完成的代理任务id
     * @Author：SYQ
     * @Date：2022/6/29 13:45
     */
    List<Long> getCompleteAgentBacklog(String agentPerformerId);

    /**
     * 查询任务真实执行人
     * @backlogIds 任务ID集合
     * @return
     */
    List<PtmAgentPerformerDTO> queryAgentPerformerList(List<Long> backlogIds);
}
