package com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.impl;

import com.digiwin.athena.abt.application.aspect.ptm.PtmException;
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.*;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.core.meta.constants.PtmApiConstant;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.*;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmAgentPerformerDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCardITraceDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmTaskCardITraceDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.ReassignTrace;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@Service
@Slf4j
public class PtmServiceImpl implements PtmService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private HttpAssistantServiceImpl httpAssistantService;


    /**
     * 获取项目记录详情(ptm_project表)
     *
     * @param projectId
     * @return
     */
    @Override
    @PtmException
    public PtmProjectRecordBO getProjectRecord(Long projectId) {
        PtmProjectRecordBO result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_PROJECT_ID_PROJECT_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("projectId", projectId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<PtmProjectRecordBO>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<PtmProjectRecordBO>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 获取任务记录详情(ptm_task表)
     *
     * @param taskId
     * @return
     */
    @Override
    @PtmException
    public PtmTaskRecordBO getTaskRecord(Long taskId,Long workItemId) {
        PtmTaskRecordBO result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_TASK_ID_TASK_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("taskId", taskId);
        param.put("workItemId", workItemId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<PtmTaskRecordBO>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<PtmTaskRecordBO>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 获取活动记录详情(ptm_activity表)
     *
     * @param activityId
     * @return
     */
    @Override
    public PtmActivityRecordDTO getActivityRecord(Long activityId) {
        PtmActivityRecordDTO result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_TASK_ACTIVITY_ID_ACTIVITY_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("activityId", activityId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<PtmActivityRecordDTO>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<PtmActivityRecordDTO>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 获取待办的记录详情(ptm_backlog 表记录)
     *
     * @param backlogId
     * @return
     */
    @Override
    @PtmException
    public PtmBacklogRecordDTO getBacklogRecord(Long backlogId) {
        PtmBacklogRecordDTO result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_TASK_ACTIVITY_ITEM_BACKLOG_ID_BACKLOG_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("backlogId", backlogId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<PtmBacklogRecordDTO>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<PtmBacklogRecordDTO>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 获取事项的记录详情(ptm_task_activity_item 表记录)
     *
     * @param workItemId
     * @return
     */
    @Override
    @PtmException
    public PtmWorkItemRecordBO getWorkItemRecord(Long workItemId) {
        PtmWorkItemRecordBO result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_TASK_ACTIVITY_ITEM_ID_WORK_ITEM_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("workItemId", workItemId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<PtmWorkItemRecordBO>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<PtmWorkItemRecordBO>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 根据backlogId获取全部的任务列表
     *
     * @param backlogId 待办id
     * @return
     */
    @Override
    @PtmException
    public List<PtmBacklogItemBO> getBacklogByBacklogId(Long backlogId) {
        List<PtmBacklogItemBO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.TASK_CARD_TASK_LIST_BACKLOG_ID_BACKLOG_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("backlogId", backlogId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmBacklogItemBO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogItemBO>>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 获取项目卡记录详情（ptm_project_card表）
     *
     * @param projectCardId
     * @return
     */
    @Override
    @PtmException
    public PtmProjectCardRecordDTO getProjectCardRecord(Long projectCardId) {
        PtmProjectCardRecordDTO result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_PROJECT_CARD_ID_PROJECT_CARD_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("projectCardId", projectCardId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<PtmProjectCardRecordDTO>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<PtmProjectCardRecordDTO>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 获取 项目 的路线列表
     *
     * @param projectId
     * @return
     */
    @Override
    public PtmProjectCardRouteDTO getProjectRoute(Long projectId) {
        PtmProjectCardRouteDTO result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.PROJECT_ROUTES_ID_PROJECT_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("projectId", projectId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<PtmProjectCardRouteDTO>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<PtmProjectCardRouteDTO>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 根据待办id获取任务卡的data、stateData
     *
     * @param backlogId ptm_backlog.id
     * @param type      非必填，传data，只返回data节点；传dataState，只返回dataState节点；不传都返回，后续异常排除任务卡查询数据可复用
     * @return data 取的是ptm.activity 的 data
     */
    @Override
    public List<PtmTaskCardDataDTO> getTaskDataByBacklogId(Long backlogId, String type) {
        return getTaskData(backlogId, null, null, type);
    }

    @PtmException
    public List<PtmTaskCardDataDTO> getTaskData(Long backlogId, Long activityId, Long taskId, String type) {
        List<PtmTaskCardDataDTO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.TASK_CARD_DATA;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        if (Objects.nonNull(backlogId)) {
            rootPara.put("backlogId", backlogId);
        }
        if (Objects.nonNull(activityId)) {
            rootPara.put("activityId", activityId);
        }
        if (Objects.nonNull(taskId)) {
            rootPara.put("taskId", taskId);
        }
        rootPara.put("type", type);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmTaskCardDataDTO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskCardDataDTO>>>() {
        }, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 批量 获取任务记录详情(ptm_task表)
     *
     * @param taskIds
     * @return 没有值慢返回空集合
     */
    @PtmException
    @Override
    public List<PtmTaskRecordBO> getTaskRecordByTaskIds(List<Long> taskIds) {
        List<PtmTaskRecordBO> result;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_TASK_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("idList", taskIds);
        //不需要data，传needData为false，目的优化ptm内存消耗
        //needData不传或者传true，ptm都是默认查data，atmc中查此接口的业务均不需要data
        rootPara.put("needData", false);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmTaskRecordBO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskRecordBO>>>() {
        }, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 批量 获取活动记录详情(ptm_activity表)
     *
     * @param activityIds
     * @return 没有值慢返回空集合
     */
    @Override
    @PtmException
    public List<PtmActivityRecordDTO> getActivityRecordByActivityIds(List<Long> activityIds) {
        List<PtmActivityRecordDTO> result = new ArrayList<>();

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_TASK_ACTIVITY_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("idList", activityIds);

        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmActivityRecordDTO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmActivityRecordDTO>>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 批量-获取项目 记录详情(ptm_project表)
     * 警告：使用次方法前请确认是否需要项目列表中的data，如果不需要，请使用getProjectRecordByProjectIdsV2替代，需要data会消耗ptm较多内存
     *
     * @param projectIds
     * @return 没有值慢返回空集合
     */
    @Override
    public List<PtmProjectRecordBO> getProjectRecordByProjectIds(List<Long> projectIds) {
        return getProjectRecordByProjectIdsV2(projectIds, true);
    }

    /**
     * 批量-获取项目 记录详情(ptm_project表)
     *
     * @param projectIds
     * @param needData   是否需要data数据，默认为需要
     * @return 没有值慢返回空集合
     */
    @Override
    @PtmException
    public List<PtmProjectRecordBO> getProjectRecordByProjectIdsV2(List<Long> projectIds, boolean needData) {
        List<PtmProjectRecordBO> result;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_PROJECT_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("idList", projectIds);
        //如果不需要data，传needData为false，目的优化ptm内存消耗
        //needData不传或者传true，ptm都是默认查data
        rootPara.put("needData", needData);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmProjectRecordBO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectRecordBO>>>() {
        }, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 批量 获取事项 的记录详情(ptm_task_activity_item 表记录)
     *
     * @param workItemIds
     * @return 没有值慢返回空集合
     */
    @Override
    @PtmException
    public List<PtmWorkItemRecordBO> getWorkItemRecordByWorkItemIds(List<Long> workItemIds) {
        List<PtmWorkItemRecordBO> result = new ArrayList<>();

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_TASK_ACTIVITY_ITEM_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("idList", workItemIds);

        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmWorkItemRecordBO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmWorkItemRecordBO>>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 根据异常排除任务id查询发起的签核任务
     *
     * @param backlogId
     * @return
     */
    @Override
    public List<PtmSolveTask> getSolveTaskListV2(Long backlogId) {
        List<PtmSolveTask> result = null;
        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.V_2_BACKLOG_SOLVE_TASK_LIST_BACKLOG_ID_BACKLOG_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("backlogId", backlogId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmSolveTask>>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmSolveTask>>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 根据backlogId获取全部的任务列表
     *
     * @param backlogIdList 待办id
     * @return
     */
    @Override
    @PtmException
    public List<PtmBacklogItemBO> getBacklogByBacklogIds(List<Long> backlogIdList) {
        List<PtmBacklogItemBO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.TASK_CARD_TASK_LIST_BATCH;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("backlogIds", backlogIdList);

        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmBacklogItemBO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogItemBO>>>() {
        }, param);

        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 获取指定工作项 被发起退回重签或重办的 工作项，可能为null
     *
     * @param type             0 或 null，同一个任务，指签核任务内；1-不是同一个任务
     * @param workItemId
     * @param approvalTaskCode 要查询的签核任务code
     * @return 可能为null
     */
    @Override
    @PtmException
    public PtmWorkItemRecordBO getReExecuteWorkItem(Integer type, Long workItemId, String approvalTaskCode) {
        PtmWorkItemRecordBO result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.TASK_CARD_PREVIOUS_ITEM;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("id", workItemId);
        rootPara.put("type", type);
        if (StringUtils.isNotBlank(approvalTaskCode)) {
            rootPara.put("taskDefCode", approvalTaskCode);
        }
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<PtmWorkItemRecordBO>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<PtmWorkItemRecordBO>>() {
        }, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 根据异常排除待办id获取新发起项目的 所有的任务列表
     *
     * @param originalBacklogIds
     * @return
     */
    @Override
    public List<Map> getSolveTaskList(List<Long> originalBacklogIds) {
        List<Map> result = new ArrayList<>();
        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.TASK_CARD_SOLVE_TASK_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("originalBacklogIds", originalBacklogIds);

        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);

        //请求接口
        ResponseEntity<BaseResultDTO<List<Map>>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<Map>>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 获取 项目卡 详情
     *
     * @param projectCardId
     * @return
     */
    @Override
    @PtmException
    public PtmProjectCardDetailDTO getProjectCardDetail(Long projectCardId) {
        PtmProjectCardDetailDTO result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.PROJECT_CARD_DETAIL_ID_PROJECT_CARD_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("projectCardId", projectCardId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<PtmProjectCardDetailDTO>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<PtmProjectCardDetailDTO>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskCardItemBO> queryTaskCardListByCodes(List<String> codes) {
        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("codes", codes);
        return reqPtmTaskCard(rootPara, PtmApiConstant.TASK_CARD_PROCESSING_SIMPLIFY_LIST);
    }

    @Override
    public List<PtmProjectCardItemDTO> queryProjectCardListByCodes(List<String> codes) {
        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.PROJECT_CARD_PROCESSING_SIMPLIFY_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取列表时，传当前token，如果使用代理token，获取的就是代理token的列表
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("codes", codes);
        return httpAssistantService.post(new TypeReference<List<PtmProjectCardItemDTO>>() {
        }, url, headers, rootPara);
    }

    private List<PtmTaskCardItemBO> reqPtmTaskCard(Map<String, Object> params, String reqUrl) {
        List<PtmTaskCardItemBO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + reqUrl;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取列表时，传当前token，如果使用代理token，获取的就是代理token的列表
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());


        result = httpAssistantService.post(new TypeReference<List<PtmTaskCardItemBO>>() {
        }, url, headers, params);

        if (result == null) {
            result = new ArrayList<>();
        }
        return result;
    }

    @Override
    public List<ReassignTrace> selectReassignOrHandoverTrace(String workItemId, Integer type) {

        if (StringUtils.isBlank(workItemId)) {
            return new ArrayList<>();
        }
        // 请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.V_2_WORK_ITEM_REASSIGN_HANDOVER_TRACE;
        // 头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        // 参数
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("fromWorkItemId", workItemId);
        paramMap.put("traceType", type);
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<ReassignTrace>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<ReassignTrace>>>() {
        }, paramMap);
        return Objects.requireNonNull(responseEntity.getBody()).getResponseWithException("");
    }

    /**
     * 批量 获取待办的记录详情(ptm_backlog 表记录)
     *
     * @param backlogIds
     * @return
     */
    @Override
    public List<PtmBacklogRecordDTO> getBacklogRecordByBacklogIds(List<Long> backlogIds) {
        List<PtmBacklogRecordDTO> result = new ArrayList<>();

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_TASK_ACTIVITY_ITEM_BACKLOG_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("idList", backlogIds);

        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmBacklogRecordDTO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogRecordDTO>>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskCardDataDTO> getTaskDataByBacklogIds(List<Map<String, Object>> backlogIds, String type, String isAllQuery) {
        return getTaskData(backlogIds, null, null, type, isAllQuery);
    }

    public List<PtmTaskCardDataDTO> getTaskData(List<Map<String, Object>> backlogIds, Long activityId, Long taskId, String type, String isAllQuery) {
        List<PtmTaskCardDataDTO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.TASK_CARD_DATA_BATCH;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        if (Objects.nonNull(backlogIds)) {
            rootPara.put("taskDataRequireKeyModels", backlogIds);
        }
        if (Objects.nonNull(activityId)) {
            rootPara.put("activityId", activityId);
        }
        if (Objects.nonNull(taskId)) {
            rootPara.put("taskId", taskId);
        }
        rootPara.put("type", type);
        rootPara.put("isAllQuery", isAllQuery);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmTaskCardDataDTO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskCardDataDTO>>>() {
        }, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmSpecialBacklogDTO> getSpecialBacklog(List<Long> workItemIds) {

        if (CollectionUtils.isEmpty(workItemIds)) {
            return null;
        }
        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.V_2_DERIVE_CARDS;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("workItemIds", workItemIds);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmSpecialBacklogDTO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmSpecialBacklogDTO>>>() {
        }, rootPara);
        return Objects.requireNonNull(responseEntity.getBody()).getResponseWithException("");
    }

    /**
     * 获取指定工作项 被发起退回重签或重办的 工作项，可能为null
     *
     * @param type             0 或 null，同一个任务，指签核任务内；1-不是同一个任务
     * @param backlogId
     * @param approvalTaskCode 要查询的签核任务code
     * @return 可能为null
     */
    @Override
    public Map<Long, TaskActivityItemVO> getReExecuteWorkItemByBacklogId(Integer type, Long backlogId, String approvalTaskCode) {
        Map<Long, TaskActivityItemVO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.TASK_CARD_PREVIOUS_ITEM_BY_BACKLOG_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("backlogId", backlogId);
        rootPara.put("type", type);
        if (StringUtils.isNotBlank(approvalTaskCode)) {
            rootPara.put("taskDefCode", approvalTaskCode);
        }
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<Map<Long, TaskActivityItemVO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map<Long, TaskActivityItemVO>>>() {
        }, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 根据 项目卡Id 查询ptm项目卡列表
     *
     * @param projectCardIdList 要查询的项目卡id
     * @return 没有值则返回空 List
     */
    @Override
    public List<PtmProjectCardItemDTO> queryProjectCardListByProjectCardId(List<Long> projectCardIdList, String autherUserId) {
        return queryProjectCard(null, projectCardIdList, autherUserId,false);
    }

    /**
     * 查询ptm项目卡列表
     */
    private List<PtmProjectCardItemDTO> queryProjectCard(List<String> userIds, List<Long> projectCardIdList, String autherUserId,Boolean queryTrace) {
        List<PtmProjectCardItemDTO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.PROJECT_CARD_PROCESSING_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取列表时，传当前token，如果使用代理token，获取的就是代理token的列表
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        log.info("queryProjectCard-authoredUser:{}", JsonUtils.objectToString(authoredUser));
        headers.add("token", authoredUser.getToken());
        String userId = StringUtils.isBlank(autherUserId) ? authoredUser.getUserId() : autherUserId;
//        headers.add("locale", userService.getUserLangMetadataAllTenant(userId, authoredUser.getToken()));

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        if (CollectionUtils.isNotEmpty(userIds)) {
            rootPara.put("userIds", userIds);
        }
        if (CollectionUtils.isNotEmpty(projectCardIdList)) {
            rootPara.put("projectCardIds", projectCardIdList);
        }
        //设置查询追踪来源数据标识,为true则再ptm查询接口中会去查询卡片的来源数据  为了避免ptm接口每次都执行这段逻辑，这里加上标识
        if (Boolean.TRUE.equals(queryTrace)){
            rootPara.put("queryTrace", queryTrace);
        }
        result = httpAssistantService.post(new TypeReference<List<PtmProjectCardItemDTO>>() {
        }, url, headers, rootPara);

        if (result == null) {
            result = new ArrayList<>();
        }
        return result;
    }

    /**
     * 批量-获取指定项目卡中最近一次项目记录<br>
     * 不含data数据
     *
     * @param projectCardIds
     * @return
     */
    @Override
    public List<PtmProjectRecordBO> getLastProjectRecordByProjectCardIds(List<Long> projectCardIds) {
        List<PtmProjectRecordBO> result = new ArrayList<>();

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.PROJECT_CARD_PROCESSING_LATEST_PROJECT_BATCH;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("projectCardIds", projectCardIds);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmProjectRecordBO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectRecordBO>>>() {
        }, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

    /**
     * 处理数据 查询项目卡卡片状态/来源/去向
     * @param list
     * @param userId
     * @return
     */
    @Override
    public List<PtmProjectCardITraceDTO> queryProjectCardTrace(List<Long> list,String userId) {
        List<PtmProjectCardITraceDTO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.PROJECT_CARD_TRACE_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取列表时，传当前token，如果使用代理token，获取的就是代理token的列表
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        log.info("queryProjectCard-authoredUser:{}", JsonUtils.objectToString(authoredUser));
        headers.add("token", authoredUser.getToken());

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("userId", userId);
        rootPara.put("projectCardIds", list);
        result = httpAssistantService.post(new TypeReference<List<PtmProjectCardITraceDTO>>() {
        }, url, headers, rootPara);

        if (result == null) {
            result = new ArrayList<>();
        }
        return result;
    }

    /**
     * 处理数据 查询任务卡卡片状态/来源/去向
     * @param taskCards
     * @param userId
     * @return
     */
    @Override
    public List<PtmTaskCardITraceDTO> queryTaskCardTrace(List<Long> taskCards, String userId) {
        List<PtmTaskCardITraceDTO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.Task_CARD_TRACE_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取列表时，传当前token，如果使用代理token，获取的就是代理token的列表
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        log.info("queryProjectCard-authoredUser:{}", JsonUtils.objectToString(authoredUser));
        headers.add("token", authoredUser.getToken());

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("userId", userId);
        rootPara.put("taskCardIds", taskCards);
        result = httpAssistantService.post(new TypeReference<List<PtmTaskCardITraceDTO>>() {
        }, url, headers, rootPara);

        if (result == null) {
            result = new ArrayList<>();
        }
        return result;
    }
    @Override
    public List<Map<String,String>> queryBacklogIds(List<Long> ids, String type, String code) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.BACKLOG_ID_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("ids", ids);
        rootPara.put("type", type);
        rootPara.put("code", code);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<Map<String,String>>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<Map<String,String>>>>() {
        }, rootPara);
        return Objects.requireNonNull(responseEntity.getBody()).getResponseWithException("");
    }

    @PtmException
    @Override
    public List<Long> getCompleteAgentBacklog(String agentPerformerId) {
        List<Long> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.TASK_CARD_AGENT_BACKLOG_AGENT_PERFORM_ID_AGENT_PERFORM_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("agentPerformId", agentPerformerId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<Long>>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<Long>>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result == null ? new ArrayList<>() : result;
    }


    /**
     * 根据任务信息获取执行人
     *
     * @param backlogIds
     * @return
     */
    @PtmException
    @Override
    public List<PtmAgentPerformerDTO> queryAgentPerformerList(List<Long> backlogIds) {
        List<PtmAgentPerformerDTO> result = Lists.newArrayList();

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.V_2_WORKITEM_PERFORMER_INFO_BY_BACKLOG_IDS;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        headers.add("routerKey", authoredUser.getTenantId());
//        headers.add("locale", userService.getUserLangMetadataAllTenant(authoredUser.getUserId(), authoredUser.getToken()));

        //入参
        Map<String, Object> param = Maps.newHashMap();
        param.put("backlogIds", backlogIds);
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);

        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmAgentPerformerDTO>>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmAgentPerformerDTO>>>() {
        }, param);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }

}
