package com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap;

import cn.hutool.json.JSONObject;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmAppDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmTaskDefineResponseDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import net.sf.json.JSONArray;

import java.util.List;
import java.util.Map;

public interface ThemeMapService {

    Map getActivityAction2(String tmTaskId, String tmActivityId, String pageCode);

    TmActivityResponseDTO getActivityAction(String tmTaskId, String tmActivityId, String pageCode);

    String getActivityTargetCode(String tmTaskId, String tmActivityId, String pageCode);

    Map executeFormula(String formulaId);

    /**
     * 获取指定任务的任务定义
     *
     * @param taskId
     * @return
     */
    TmTaskDefineResponseDTO getTask(String taskId);

    /**
     * @param objectType  task/activity
     * @param objectValue 项目code/任务code
     * @param user
     * @return
     */
    JSONArray getTmTaskAndActivityBk(String objectType, String objectValue, AuthoredUser user);

    /**
     * @param codeList 任务code  项目code  基础资料code  报表code  发起项目code
     * @param type     项目/发起项目 project    任务/基础资料/报表  task
     * @return
     */
    List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList);


    String getTaskNamesByCodes(String codes);

    String getProjectNamesByCodes(String codes);

    /**
     * 批量获取项目的转派定义
     *
     * @param taskCodes 项目code列表
     * @return
     */
    List<TmTaskDefineResponseDTO> getBatchTaskAssigns(List<String> taskCodes);

    Map<String,Object> postCardConfigByType(JSONObject jsonObject);

    /**
     * 批量获取任务的转派定义
     *
     * @param activities map结构 {"taskCode":"task_RE_Preparation","activityCode":"purchaseApproval"}
     * @return
     */
    List<TmActivityResponseDTO> getBatchActivityAssigns(List<Map> activities);

    Map<String,Object> getTaskCardOptimizeRules();

    Map<String,List<String>> getActivityDefinitionList(List<String> list);

    String getAppCode(String type, String code);
}
