package com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.impl;/*
 * Copyright (C), 2001-2024, 鼎捷软件股份有限公司
 * FileName: com.digiwin.athena.atmc.application.service.restful.thememap.impl
 * Author:   杨尹(22191)
 * Date:     2024/9/5 20:33
 * Description: // 模块目的、功能描述
 * History:		// 修改记录
 * <author>		<time>		<version>		<desc>
 * 22191		2024/9/5 20:33		1.0		<描述>
 */
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.service.atmc.migration.cache.CacheQService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapQService;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.CardPresentConfigBO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.time.Duration;
import java.util.List;
import java.util.Map;

/**
 * @version v1.0
 * @Description: TODO
 * <p>〈功能详细描述〉</p>
 *
 * <pre>
 * 〈举例说明〉
 * </pre>
 * @ClassName ThemeMapQServiceImpl
 * @author 杨尹(22191)
 * @date 2024/9/5 20:33
 */
@Slf4j
@Service
public class ThemeMapQServiceImpl implements ThemeMapQService {

    private static final int NOT_NEED_SEARCH = -999;
    private static final String APPLY_PROJECT_TYPE_STR = "2";
    private static final String APPLY_ENTRY_TYPE_STR = "3";
    private static final String APPLY_REPORT_TYPE_STR = "4";

    private static final String REPORT_PATTERN = "STATEMENT";
    public static final String BASE_DATA_PATTERN = "DATA_ENTRY";


    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    @Autowired
    private CacheQService cacheQService;

    private String getToken() {
        // 优先使用代理token
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken();
        } else {
            return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        }
    }

    private AuthoredUser getAuthoredUser() {
        // 优先使用代理token
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser();
        } else {
            return AppAuthContextHolder.getContext().getAuthoredUser();
        }
    }

    @Override
    public List<CardPresentConfigBO> getCardPresentConfigs(String pageCode) {

        /**
         * 定义redis key
         */
        String redisKey = "getCardPresentConfigs:" + getAuthoredUser().getTenantId() + ":" + pageCode;

        /**
         * 获取缓存内容
         */
        String json = (String) cacheQService.get(redisKey);
        if (json != null) {
            return JsonUtils.jsonToListObject(json, CardPresentConfigBO.class);
        }

        /**
         * 无缓存内容，获取km数据
         */
        List<CardPresentConfigBO> cardPresentConfigBOS =
                reqThemeMapList(new ParameterizedTypeReference<BaseResultDTO<List<CardPresentConfigBO>>>() {
                                                                         }, HttpMethod.GET,
                "/restful/service/knowledgegraph/workbenchSetting/cardPresentConfig?pageCode=" + pageCode, null);

        /**
         * 缓存1小时失效
         */
        cacheQService.cache(redisKey, JsonUtils.objectToString(cardPresentConfigBOS), Duration.ofMinutes(60L));

        return cardPresentConfigBOS;
    }

    private <T> T reqThemeMapList(ParameterizedTypeReference<BaseResultDTO<T>> typeReference, HttpMethod httpMethod, String url, Map<String, Object> body){
        url = envProperties.getKnowledgeGraphUri() + url;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        HttpEntity<?> requestEntity = new HttpEntity<>(body, headers);
        ResponseEntity<BaseResultDTO<T>> respEntity = this.restTemplate.exchange(url,httpMethod, requestEntity,
                typeReference);
        BaseResultDTO<T> baseResultDTO = respEntity.getBody();
        assert baseResultDTO != null;
        return baseResultDTO.getResponse();
    }

}
