package com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.*;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.constants.KgApiConstant;
import com.digiwin.athena.abt.core.meta.constants.ManualTaskConstant;
import com.digiwin.athena.abt.core.meta.enums.AtmcErrorCodeEnum;
import com.digiwin.athena.abt.core.uiils.BusinessExceptionUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@Service
@Slf4j
public class ThemeMapServiceImpl implements ThemeMapService {
    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    @Override
    public Map getActivityAction2(String tmTaskId, String tmActivityId, String pageCode) {

        Map result = null;

        String uri = envProperties.getDataMapUri() + KgApiConstant.TASK_ACTIVITY_DEFINITION_TASK_ID_ACTIVITY_ID_PAGE_CODE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);

        try{
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<BaseResultDTO<Map>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map>>() {
            }, param);
            result = responseEntity.getBody().getResponseWithException("");
            return result;
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
    }

    @Override
    public TmActivityResponseDTO getActivityAction(String tmTaskId, String tmActivityId, String pageCode) {

        TmActivityResponseDTO result = null;

        String uri = envProperties.getDataMapUri()+ KgApiConstant.TASK_ACTIVITY_DEFINITION_TASK_ID_ACTIVITY_ID_PAGE_CODE;
        if(ManualTaskConstant.VIRTUAL_PROJECT.equals(tmTaskId)){
            uri = envProperties.getDataMapUri() + KgApiConstant.TASK_ACTIVITY_DEFINITION_ACTIVITY_ID_PAGE_CODE;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<TmActivityResponseDTO>> respEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmActivityResponseDTO>>() {
                    }, param);
            BaseResultDTO<TmActivityResponseDTO> resultDTO = respEntity.getBody();
            if (resultDTO == null) {
                throw AtmcErrorCodeEnum.KM_RTN_ERROR.getBusinessExceptionWithArgs(tmActivityId);
            }
            // 业务异常
            if (!resultDTO.isOK()) {
                throw BusinessExceptionUtils.getBusinessException(respEntity.getStatusCodeValue(), resultDTO.getErrorCode(), resultDTO.getErrorMessage(), uri, null);
            }
            // 应用过期
            result = resultDTO.getResponse();
        } catch (RestClientException ex) {
            //响应体解析错误
            if (ex.getCause() instanceof HttpMessageConversionException) {
                throw AtmcErrorCodeEnum.KM_RTN_ERROR.getBusinessExceptionWithArgs(tmActivityId);
            }
            throw ex;
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
        if (result != null) {
            //xuxx 2022-11-01 调整xxx-card中增加DataStates，将原有card中的内容全部移动到DataStates中，如果同时存在，以DataStates里的为主
            if(result.getPages() != null && CollectionUtils.isNotEmpty(result.getPages().getDataStates()) && result.getPages().getDataStates().size()>0 ){
                TmDataState dataState = result.getPages().getDataStates().get(0);
                result.getPages().setCardCache(dataState.getCardCache());
            }
            //需要兼容以前的，暂时不能删除
            if (result.getPages() != null && result.getPages().getCardCache() == null) {
                //未设置是否缓存，默认缓存
                result.getPages().setCardCache(true);
            }

            if (result.getAssignAble() == null) {
                //assignAble如果为Null，则默认为true
                result.setAssignAble(true);
            }
            if (Objects.equals(result.getAssignAble(), Boolean.TRUE) && result.getAssignConfig() == null) {
                TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder()
                        .assignAble(result.getAssignAble())
                        .assignTo(result.getAssignTo())
                        .build();
                result.setAssignConfig(assignConfig);
            }
        } else {
            throw AtmcErrorCodeEnum.KM_RTN_NULL.getBusinessExceptionWithArgs(tmActivityId);
        }
        return result;

    }

    /**
     * 获取任务的关联任务code
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param pageCode
     * @return
     */
    @Override
    public String getActivityTargetCode(String tmTaskId, String tmActivityId, String pageCode) {

        TmActivityResponseDTO result = new TmActivityResponseDTO();

        String uri = envProperties.getDataMapUri() + KgApiConstant.TASK_ACTIVITY_START_TARGET_CODE_TASK_ID_ACTIVITY_ID_PAGE_CODE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<BaseResultDTO<TmActivityResponseDTO>> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmActivityResponseDTO>>() {
                    },param);
            result = responseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
        if (result != null) {
            //未设置是否缓存，默认缓存
            return result.getTargetApproveActivity();
        }
        return null;

    }

    @Override
    public Map executeFormula(String formulaId) {
        Map result = null;

        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.TENANT_SETTINGS_FORMULA;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String, String> param = new HashMap<>();
        param.put("formulaId", formulaId);
        try {
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<BaseResultDTO<Map>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,  new ParameterizedTypeReference<BaseResultDTO<Map>>(){
            }, param);
            result = responseEntity.getBody().getResponseWithException("");
            return result;
        }catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
    }

    /**
     * 获取指定任务的任务定义
     *
     * @param taskId
     * @return
     */
    @Override
    public TmTaskDefineResponseDTO getTask(String taskId) {

        TmTaskDefineResponseDTO result = null;

        String uri = envProperties.getDataMapUri() + KgApiConstant.TASK_DEFINITION_WITH_MULTI_LANGUAGE_TASK_ID;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("taskId", taskId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<BaseResultDTO<TmTaskDefineResponseDTO>> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmTaskDefineResponseDTO>>() {
                    }, param);
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
        result = Objects.requireNonNull(responseEntity.getBody()).getResponseWithException("");

        if (result != null) {
            if (result.getMerge() == null) {
                //merge如果为null，则默认为true
                result.setMerge(true);
            }
            if (result.getAssignAble() == null) {
                //assignAble如果为Null，则默认为true
                result.setAssignAble(true);
            }
            if (Objects.equals(result.getAssignAble(), Boolean.TRUE) && result.getAssignConfig() == null) {
                TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder()
                        .assignAble(result.getAssignAble())
                        .assignTo(result.getAssignTo())
                        .build();
                result.setAssignConfig(assignConfig);
            }
        }
        return result;

    }

    @Override
    public JSONArray getTmTaskAndActivityBk(String objectType, String objectValue, AuthoredUser user) {
        JSONArray result = null;
        String url = "";
        try {
            //请求地址
            url = envProperties.getKnowledgeGraphUri() + KgApiConstant.VIEW_BK;
            //头部
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            log.info("current user: "+user);
            if (null == user) {
                headers.set("token", getToken());
                log.info(" context token: " + getToken());
            } else {
                headers.set("token", user.getToken());
            }
            //入参
            Map<String, String> paramDetailMap = new HashMap<>();
            paramDetailMap.put("objectType", objectType);
            paramDetailMap.put("objectValue", objectValue);
            Map<String, Map<String, String>> paramMap = new HashMap<>();
            paramMap.put("request", paramDetailMap);
            HttpEntity<?> httpEntity = new HttpEntity<>(paramMap, headers);
            //请求接口
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, BaseResultDTO.class);
            Object response = responseEntity.getBody().getResponseWithException("");
            if (response != null) {
                // 解决net.sf.json 将null解析成"null"的问题
                JSONObject jsonObject = JsonUtils.jsonToObject(JsonUtils.objectToString(response), JSONObject.class);
                if (jsonObject.containsKey("bkInfo")) {
                    result = jsonObject.getJSONArray("bkInfo");
                }
            }
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
        return result;
    }

    @Override
    public List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList) {

        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_APPLICATION_RELATION;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, Object> params = new HashMap<>();
        params.put("type", type);
        params.put("codes", codeList);
        HttpEntity<?> httpEntity = new HttpEntity<>(params,headers);
        ResponseEntity<BaseResultDTO<List<TmAppDTO>>> respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>() {
            });
            log.info("[getAppInfoByCodeAndType]  type = {}, codes = {}, result = {}", type, JsonUtils.objectToString(codeList), JsonUtils.objectToString(respEntity));
        }
        catch (Exception e){
            log.error("[getAppInfoByCodeAndType] execute km [knowledgegraph/task/applicationRelation] fail, error = {}", e.getMessage());
        }

        if (null != respEntity && null != respEntity.getBody()){
            return  respEntity.getBody().getResponseWithException("");
        }
        return null;
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }

    private String getToken() {
        // 优先使用代理token
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken();
        } else {
            return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        }
    }


    @Override
    public String getTaskNamesByCodes(String code) {
        List<String> codes = new ArrayList<>();
        codes.add(code);
        String url = envProperties.getDataMapUri() + KgApiConstant.TASK_NAME;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String,Object> params = new HashMap<>();
        Map<String,Object> query = new HashMap<>();
        query.put("code",codes);
        params.put("query",query);
        HttpEntity<?> httpEntity = new HttpEntity<>(params,headers);
        ResponseEntity<BaseResultDTO<List<Map>>> respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<Map>>>() {
            });
            log.info("[getTaskName]  codes = {}, result = {}", JsonUtils.objectToString(codes), JsonUtils.objectToString(respEntity));
        }
        catch (Exception e){
            log.error("[getTaskName] execute datamap [/view/taskNamesByCodes] fail, error = {}", e.getMessage());
        }

        if (null != respEntity && null != respEntity.getBody()){
            List<Map> tasks = respEntity.getBody().getResponseWithException("");
            if (!tasks.isEmpty()) {
                Map map = tasks.get(0);
                return JSON.toJSONString(JSONPath.eval(map, "$.lang.name"));
            }
        }
        return null;
    }

    @Override
    public String getProjectNamesByCodes(String code) {
        List<String> codes = new ArrayList<>();
        codes.add(code);
        String url = envProperties.getDataMapUri() + KgApiConstant.PROJECT_NAME;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String,Object> params = new HashMap<>();
        Map<String,Object> query = new HashMap<>();
        query.put("code",codes);
        params.put("query",query);
        HttpEntity<?> httpEntity = new HttpEntity<>(params,headers);
        ResponseEntity<BaseResultDTO<List<Map>>> respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<Map>>>() {
            });
            log.info("[getTaskName]  codes = {}, result = {}", JsonUtils.objectToString(codes), JsonUtils.objectToString(respEntity));
        }
        catch (Exception e){
            log.error("[getTaskName] execute datamap [/view/taskNamesByCodes] fail, error = {}", e.getMessage());
        }

        if (null != respEntity && null != respEntity.getBody()){
            List<Map> tasks = respEntity.getBody().getResponseWithException("");
            if (!tasks.isEmpty()) {
                Map map = tasks.get(0);
                return JSON.toJSONString(JSONPath.eval(map, "$.lang.name"));
            }
        }
        return null;
    }
    /**
     * 批量获取项目的转派定义
     *
     * @param taskCodes 项目code列表
     * @return
     */
    public List<TmTaskDefineResponseDTO> getBatchTaskAssigns(List<String> taskCodes) {
        List<TmTaskDefineResponseDTO> result = null;

        //请求地址
        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.BATCH_TASK_BASIC;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //入参
        Map<String, Object> rootPara = new HashMap<>();
        Map<String, Object> qPara = new HashMap<>();
        qPara.put("codes", taskCodes);
        rootPara.put("q", qPara);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<TmTaskDefineResponseDTO>>> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<TmTaskDefineResponseDTO>>>() {
            }, rootPara);
            result = responseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
        if (CollectionUtils.isNotEmpty(result)) {
            result.forEach(x -> {
                if (x.getAssignAble() == null) {
                    x.setAssignAble(true);
                }

                if (Objects.equals(x.getAssignAble(), Boolean.TRUE) && x.getAssignConfig() == null) {
                    TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder()
                            .assignAble(x.getAssignAble())
                            .assignTo(x.getAssignTo())
                            .build();
                    x.setAssignConfig(assignConfig);
                }
            });
        }
        return result;
    }

    @Override
    public Map<String, Object> postCardConfigByType(cn.hutool.json.JSONObject jsonObject) {
        String url = envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/cardConfigByType";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        Map<String, Object> result = new HashMap<>();
        Map<String, Object> body = new HashMap<>();
        body.put("cardConfigQuery",jsonObject);
        HttpEntity<?> requestEntity = new HttpEntity<>(body, headers);
        try {
            cn.hutool.json.JSONObject respJson= this.restTemplate.postForObject(url, requestEntity, cn.hutool.json.JSONObject.class);
            Map<String, Object> map = JsonUtils.jsonToObject(respJson.toJSONString(0), new TypeReference<Map<String, Object>>() {
            });
            result =  (Map<String, Object>) map.get("response");
            return result;
        } catch (Exception e) {
            log.error("【km server error】:{}", e);
        }
        return result;
    }

    /**
     * 批量获取任务的转派定义
     *
     * @param activities map结构 {"taskCode":"task_RE_Preparation","activityCode":"purchaseApproval"}
     * @return
     */
    @Override
    public List<TmActivityResponseDTO> getBatchActivityAssigns(List<Map> activities) {
        List<TmActivityResponseDTO> result = null;

        //请求地址
        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.BATCH_ACTIVITY_BASIC;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //入参
        Map<String, Object> rootPara = new HashMap<>();
        Map<String, Object> qPara = new HashMap<>();
        qPara.put("taskAndActivities", activities);
        rootPara.put("q", qPara);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<TmActivityResponseDTO>>> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<TmActivityResponseDTO>>>() {
            }, rootPara);
            result = responseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
        if (CollectionUtils.isNotEmpty(result)) {
            result.forEach(x -> {
                if (x.getAssignAble() == null) {
                    x.setAssignAble(true);
                }

                if (Objects.equals(x.getAssignAble(), Boolean.TRUE) && x.getAssignConfig() == null) {
                    TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder()
                            .assignAble(x.getAssignAble())
                            .assignTo(x.getAssignTo())
                            .build();
                    x.setAssignConfig(assignConfig);
                }
            });
        }
        return result;
    }

    @Override
    public Map<String, Object> getTaskCardOptimizeRules() {
        //获取返回的信息
        String getAppIdUrl = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_CARD_OPTIMIZE_RULES;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, Object> result = new HashMap<>();
        Map<String, String> param = new HashMap<>();
        //查询数据
        try {
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<Map> entryResp = restTemplate.exchange(getAppIdUrl, HttpMethod.GET, httpEntity, Map.class, param);

            //获取查询结果
            if (entryResp.getStatusCode() == HttpStatus.OK && (null != entryResp.getBody())) {
                Object response = entryResp.getBody().get("response");
                if (response != null && response != "") {
                    result =  (Map<String, Object>) response;
                }
            }

        }  catch (Exception e) {
            log.error("url: {}, error: ", getAppIdUrl, e);
            throw e;
        }
        return result;
    }

    @Override
    public Map<String,List<String>> getActivityDefinitionList(List<String> list) {
        Map<String, List<String>> result = new HashMap<>();
        if (CollectionUtils.isEmpty(list)){
            return result;
        }

        String url = envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/activityDefinitionList";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        Map body = new HashMap();
        body.put("taskId", "");
        body.put("activityIds", list);
        body.put("pageCode", "task-card");

        HttpEntity<?> requestEntity = new HttpEntity<>(body, headers);
        try {
            ResponseEntity<BaseResultDTO<Map>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map>>() {
                    });
            BaseResultDTO<Map> resultDTO = respEntity.getBody();
            // 业务异常
            if (!resultDTO.isOK()) {
                throw BusinessExceptionUtils.getBusinessException(respEntity.getStatusCodeValue(), resultDTO.getErrorCode(), resultDTO.getErrorMessage(), url, null);
            }
            Map map = resultDTO.getResponse();

            list.forEach(el -> {
                Object o = map.get(el);
                cn.hutool.json.JSONObject activityDefinition = JSONUtil.parseObj(o);
                cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(activityDefinition.get("pages"));
                cn.hutool.json.JSONArray jsonArray = JSONUtil.parseArray(jsonObject.get("dataStates"));
                cn.hutool.json.JSONObject dataState = jsonArray.stream()
                        .map(e -> (cn.hutool.json.JSONObject) e)
                        .filter(e-> e.get("type")!=null)
                        .filter(e -> "all".equals(e.get("type").toString())).findFirst().get();
                cn.hutool.json.JSONObject taskCardFields = JSONUtil.parseObj(dataState.get("taskCardFields"));
                String dateSourceName ;
                if (taskCardFields.getStr("dateSourceName") == null) {
                    dateSourceName = taskCardFields.getStr("dataSourceName");
                } else {
                    dateSourceName = taskCardFields.getStr("dateSourceName");
                }
                cn.hutool.json.JSONObject dataSources = JSONUtil.parseObj(activityDefinition.get("dataSources"));
                Object dataSource = dataSources.get(dateSourceName);
                cn.hutool.json.JSONObject datasourceJson = JSONUtil.parseObj(dataSource);
                cn.hutool.json.JSONArray actionParams = JSONUtil.parseArray(datasourceJson.get("actionParams"));
                ArrayList<String> objects = new ArrayList<>();
                Optional<Object> optional = actionParams.stream()
                        .filter(e -> "PROCESS_VARIABLE".equals(((cn.hutool.json.JSONObject) e).get("type")))
                        .findFirst();
                if (optional.isPresent()) {
                    cn.hutool.json.JSONObject actionParam = JSONUtil.parseObj(optional.get());
                    String value = actionParam.getStr("value");
                    objects.add(value);
                    result.put(el, objects);
                }
            });
            return result;
        } catch (Exception e) {
            log.error("get activity error："+e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getAppCode(String type, String code) {
        Map<String, Object> paramMap = new HashMap<>();
        // 查询的编码集合
        paramMap.put("code", code);
        // 查询的类型任务activity项目task
        paramMap.put("type", type);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", getToken());
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/app/applicationByTypeAndCode?type={type}&code={code}";
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<TmApplication>> response = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmApplication>>() {
                    },
                    paramMap);
            TmApplication tmApplication = response.getBody().getResponseWithException("");
            if (null != tmApplication) {
                return tmApplication.getApplication();
            }
        } catch (Exception ex) {
            log.error("url: {}, error: ", url, ex);
        }
        return null;
    }
}
