package com.digiwin.athena.abt.application.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmDataConsistencyMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmDataProcessDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import org.springframework.util.CollectionUtils;

import java.util.*;

public final class ActivityUtils {

    static Set<String> canSetCheckItemMaps = new HashSet<>();
    static {
        canSetCheckItemMaps.add("BUSINESS-SOLVE");
        canSetCheckItemMaps.add("BUSINESS-APPROVAL");
        canSetCheckItemMaps.add("BUSINESS-MODIFY");
        canSetCheckItemMaps.add("BUSINESS-REPORT");
        canSetCheckItemMaps.add("BUSINESS-StockChange");
        canSetCheckItemMaps.add("MECHANISM-SUGGESTION");
        canSetCheckItemMaps.add("MECHANISM-APPROVAL");
        canSetCheckItemMaps.add("ADJUSTMENT-ADJUSTMENT");
    }


    public static  List<Map<String,Object>> getCheckItemsResult(TmDataProcessDTO tmDataProcessDTO, Object allDataSize){
        List<Map<String,Object>> checkItems=new ArrayList<>();

        if(tmDataProcessDTO == null
                || tmDataProcessDTO.getParas() ==null
                || tmDataProcessDTO.getParas().size() ==0
                || !tmDataProcessDTO.getParas().containsKey("checkItems")){
            return checkItems;
        }
        checkItems =  (List) tmDataProcessDTO.getParas().get("checkItems");
        for (Map<String, Object> checkItem : checkItems) {
            if (checkItem.containsKey("name")) {
                checkItem.put("item", checkItem.get("name"));
                checkItem.put("value",allDataSize);
            }
        }
        return checkItems;
    }

    public static  List<Map<String,Object>> getCountItemsResult(Object data ,boolean showInTask){
        List<Map<String, Object>> countItems = new ArrayList<>();
        if (!(data instanceof List)) {
            return countItems;
        }

        List<Map<String, Object>> dataList = (List<Map<String, Object>>) data;
        if (CollectionUtils.isEmpty(dataList)) {
            return countItems;
        }
        Map<String, Object> row = dataList.get(0);
        if (row.containsKey("count_result")) {
            List<Map<String, Object>> resultList = (List<Map<String, Object>>) row.get("count_result");
            for (Map<String, Object> map : resultList) {
                String key = map.get("key").toString();
                String name = map.get("name").toString();
                String value = map.get("value").toString();
                Map<String, Object> checkItemMap = new HashMap<>();
                checkItemMap.put("key", key);
                checkItemMap.put("keyValue", value);
                checkItemMap.put("item", name);
                checkItemMap.put("value", 0);
                countItems.add(checkItemMap);
            }
        }

        for (Map<String, Object> rowData : dataList) {
            if (row.containsKey("count_result")) {
                for (Map<String, Object> showItem : countItems) {
                    String itemKey = showItem.get("key").toString();
                    String itemkeyValue = showItem.get("keyValue").toString();
                    String itemValue = showItem.get("value").toString();
                    String rowKeyValue = rowData.get(itemKey) == null ? "" : rowData.get(itemKey).toString();
                    if (itemkeyValue.equals(rowKeyValue)) {
                        showItem.put("value", Integer.parseInt(itemValue) + 1);
                    }
                }
            }
        }
        return countItems;
    }

    /**
     * 获取N项待处理
     * @param data
     * @return
     */
    public static List<Map<String,Object>> getTodoCountItemsResult(Object data){

        List<Map<String,Object>> checkItems=new ArrayList<>();
        if (!(data instanceof List)) {
            return checkItems;
        }

        List listData = (List)data;
        Map<String,Object> ci = new HashMap<>();
        ci.put("item", SpringUtil.getBean(MessageUtils.class).getMessageWithFormat("backlog.todo",listData.size()));
        //ci.put("value",listData.size());
        checkItems.add(ci);

        return checkItems;
    }

    public static PtmDataConsistencyMessageDTO convertPtmDataConsistencyMsg(String data){
        JSONObject jsonObject = JSON.parseObject(data);
        JSONObject mqData = jsonObject.getJSONObject("data");
        if(mqData != null){
            Object o = mqData.get("workItem");
            if(o instanceof JSONObject){
                JSONArray jsonArray = new JSONArray();
                jsonArray.add(o);
                jsonObject.put("workItem",jsonArray);
            }
        }
        return jsonObject.toJavaObject(PtmDataConsistencyMessageDTO.class);
    }
}
