package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

/**
 * @Author wuzq
 * @Date 2023/6/21 16:38
 * @Description: 授权工具类
 * @Version 1.0
 */
public class AppAuthContextUtils {

    /**
     * 线程上下文设置token
     * @param virtualToken
     */
    public static AuthoredUser setAuthoredUserContext(String virtualToken) {
        AppAuthContext appAuthContext = new AppAuthContext();
        AuthoredUser authoredUser = new AuthoredUser();
        authoredUser.setToken(virtualToken);
        appAuthContext.setAuthoredUser(authoredUser);
        AppAuthContextHolder.setContext(appAuthContext);
        return authoredUser;
    }
}
