package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardActivityDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardInfoDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardItemDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class CommonUtils {

    public final static String SUMMARY_LAYOUT = "summaryLayout";
    public final static String HISTORY_MESSAGE = "historyMessage";
    public final static String SEARCH_MESSAGE = "searchMessage";

    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);

    public static <T> List<List<T>> spliceArrays(List<T> datas, int splitSize) {
        if (datas == null || splitSize < 1) {
            return  null;
        }
        int totalSize = datas.size();
        int count = (totalSize % splitSize == 0) ?
                (totalSize / splitSize) : (totalSize/splitSize+1);
        List<List<T>> rows = new ArrayList<>(splitSize);
        for (int i = 0; i < count;i++) {
            List<T> cols = datas.subList(i * splitSize,
                    (i == count - 1) ? totalSize : splitSize * (i + 1));
            rows.add(cols);
        }
        return rows;
    }

    public static List<Integer> split(String value,String split){
        String[] arr = value.split(split);
        List<Integer> strList = new ArrayList<>(arr.length);
        for (String s : arr) {
            strList.add(Integer.parseInt(s));
        }
        return strList;
    }

    public static boolean isNoBk(String active){
        return !"bk".equals(active);
    }

    public static String getActivityMessageStr(CardInfoDto cardInfoDto){
        return getActivityMessageStr(cardInfoDto, Maps.newHashMap());
    }

    public static String getActivityMessageStr(String activityMessage, Long activityId, Map<String, Object> cardData) {
        if (activityId != null && cardData != null) {
            CardActivityDto cardActivity = getCardActivity(activityMessage);
            CardInfoDto cardInfoDto = new CardInfoDto();
            cardInfoDto.setCardItemList(Lists.newArrayList(new CardItemDto[]{new CardItemDto(activityId, cardData)}));
            return cardActivity == null ? getActivityMessageStr(cardInfoDto) : getActivityMessageStr(cardInfoDto, cardActivity.getActivityMsg());
        } else {
            return activityMessage;
        }
    }

    public static CardActivityDto getCardActivity(String activityMessage) {
        if (StringUtils.isNotEmpty(activityMessage)) {
            try {
                return (CardActivityDto)JsonUtils.jsonToObject(activityMessage, CardActivityDto.class);
            } catch (Exception var2) {
                log.warn("转换活动级摘要信息错误:{},原:{}", var2.getMessage(), activityMessage);
            }
        }

        return null;
    }


    public static String getActivityMessageStr(CardInfoDto cardInfoDto,Map<Long, Map<String, Set<String>>> activityMsg){
        List<CardItemDto> cardItemList = cardInfoDto.getCardItemList();
        if(CollectionUtils.isEmpty(cardItemList) || activityMsg == null){
            return null;
        }
        for (CardItemDto cardItemDto : cardItemList) {
            Long activityId = cardItemDto.getActivityId();
            if(activityId == null){
                continue;
            }
            Map<String, Set<String>> map = activityMsg.computeIfAbsent(cardItemDto.getActivityId(), e -> new HashMap<>());
            Map<String, Object> cardInfo = cardItemDto.getCardInfo();
            addCardText(map,cardInfo,SUMMARY_LAYOUT);
            addCardText(map,cardInfo,HISTORY_MESSAGE);
            addCardText(map,cardInfo,SEARCH_MESSAGE);
        }
        CardActivityDto cardActivityDto = new CardActivityDto();
        cardActivityDto.setActivityMsg(activityMsg);
        return JsonUtils.objectToString(cardActivityDto);
    }

    private static void addCardText(Map<String, Set<String>> map,Map<String, Object> cardInfo,String key){
        Set<String> textList = map.computeIfAbsent(key, e -> new HashSet<>());
        String summaryText = MapUtils.getString(cardInfo, key);
        if(StringUtils.isNotBlank(summaryText)){
            String[] split = summaryText.split("<br>");
            for (String s : split) {
                String[] rowSplit = s.split("：");
                String[] dataSplit;
                if(rowSplit.length>1){
                    dataSplit = rowSplit[1].split(",");
                    textList.add(rowSplit[0]);
                }else{
                    dataSplit = rowSplit[0].split(",");
                }
                textList.addAll(Arrays.asList(dataSplit));
            }
        }
    }

    public static Map<String,Object> getCardMap(String summary,String history,String search){
        Map<String,Object> map = Maps.newHashMapWithExpectedSize(3);
        map.put(SUMMARY_LAYOUT,summary);
        map.put(HISTORY_MESSAGE,history);
        map.put(SEARCH_MESSAGE,search);
        return map;
    }

    /**
     *  根据path取不重复单身值
     * @param row 当前行数据
     * @param list 单身值
     * @param paths 路径
     * @param level 当前等级
     */
    public static void addDepData(Map<String, Object> row, LinkedHashSet<Object> list, String[] paths, int level) {
        Object o = row.get(paths[level]);
        if (level >= (paths.length - 1)) {
            if (o != null) {
                list.add(o);
            }
        } else {
            int nextLevel = level + 1;
            if (o instanceof Map) {
                addDepData((Map<String, Object>) o, list, paths, nextLevel);
            } else if (o instanceof List) {
                List<Map<String, Object>> dRows = (List<Map<String, Object>>) o;
                if (CollectionUtils.isNotEmpty(dRows)) {
                    for (Map<String, Object> dRow : dRows) {
                        addDepData(dRow, list, paths, nextLevel);
                    }
                }
            }
        }
    }


}
