package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.appcore.exception.BusinessException;
import lombok.SneakyThrows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

/**
 * @Author wuzq
 * @Description: 多线程功工具类
 */
public class ConcurrentSubmitUtils {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentSubmitUtils.class);

    public ConcurrentSubmitUtils(ExecutorService executorService) {
        this.executorService = executorService;
    }

    private final List<Future> futureList = new ArrayList<>();
    private final ExecutorService executorService;

    public static ConcurrentSubmitUtils build(ExecutorService executorService) {
        return new ConcurrentSubmitUtils(executorService);
    }

    public ConcurrentSubmitUtils addCollections(Runnable task) {
        futureList.add(executorService.submit(task));
        return this;
    }

    @SneakyThrows
    public void getCollectionsWithTimeout(long timeout, TimeUnit timeUnit) {
        try {
            log.info("futureList.size：" + futureList.size());
            for (Future objectFuture : futureList) {
                objectFuture.get(timeout, timeUnit);
            }
        } catch (InterruptedException e) {
            e.getStackTrace();
            log.warn("[ConcurrentSubmit InterruptedException] error:{}, stack:{}", e, e.getStackTrace());
            Thread.currentThread().interrupt();
            throw BusinessException.create(e.getMessage());
        } catch (ExecutionException e) {
            e.getStackTrace();
            log.warn("[ConcurrentSubmit ExecutionException] error:{}, stack:{}", e, e.getStackTrace());
            throw BusinessException.create(e.getMessage());
        } catch (TimeoutException e) {
            e.getStackTrace();
            futureList.forEach(future -> future.cancel(true));
            throw new RuntimeException(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }
}
