package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.abt.core.meta.constants.JobConstants;

import java.security.SecureRandom;

/**
 * CronExprUtils Description
 *
 * @author majianfu
 * @date 2023/4/3
 * @since
 */
public abstract class CronExprUtils {
    /**
     * 每小时xx分xx秒执行
     */
    private CronExprUtils() {
    }

    /**
     * 生成随机定时任务执行时间点的cron表达式，秒、分的随机生成。
     *
     * @return
     */
    public static String genRandomCronExpr() {
        SecureRandom random = new SecureRandom();
        // 秒（0-59）
        int second = random.nextInt(59);
        // 分（0-59）
        int minute = random.nextInt(59);
        return String.format(JobConstants.CRON_EXPR_FORMAT, second, minute);

//        // 每三分中执行一次
//        return "0 0/3 * * * ?";
    }
}
