package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.abt.application.dto.migration.abt.excel.CsvFile;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import org.springframework.web.multipart.MultipartFile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @program: abt
 * @description:
 * @author: Hang Liu
 * @create: 2024-06-05 13:20
 */
public class CsvUtils {


    /**
     * 解析csv文件并转成bean（方法二）
     *
     * @param file csv文件
     * @return 数组
     */
    public static List<String[]> getCsvDataMethod2(MultipartFile file) {

        List<String[]> list = new ArrayList<String[]>();
        int i = 0;
        try {
            CSVReader csvReader = new CSVReaderBuilder(
                    new BufferedReader(
                            new InputStreamReader(file.getInputStream(), "utf-8"))).build();
            Iterator<String[]> iterator = csvReader.iterator();
            while (iterator.hasNext()) {
                String[] next = iterator.next();
                //去除第一行的表头，从第二行开始
                if (i >= 1) {
                    list.add(next);
                }
                i++;
            }
            return list;
        } catch (Exception e) {
            System.out.println("CSV文件读取异常");
            return list;
        }
    }

    /**
     * 解析csv文件并转成bean（方法一）
     *
     * @param file
     * @return
     */
    public static List<CsvFile> getCsvDataMethod1(MultipartFile file) {
        ArrayList<CsvFile> csvFileList = new ArrayList<>();
        try (BufferedReader bufferedReader
                     = new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8))) {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                String[] split = line.split(",");
                CsvFile csvFile = new CsvFile();
                csvFile.setBackLogId(splitResult(split[0]));
                csvFile.setWorkItemId(splitResult(split[1]));
                csvFile.setTenantId(splitResult(split[3]));
                csvFile.setActivityId(splitResult(split[4]));
                csvFile.setTaskId(splitResult(split[5]));
                csvFile.setProjectId(splitResult(split[6]));
                csvFile.setProjectCardId(splitResult(split[7]));
                csvFileList.add(csvFile);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return csvFileList;
    }

    private static String splitResult(String once) {
        String result = "";
        for (int i = 0; i < once.length(); i++) {
            if (once.charAt(i) != '"' && once.charAt(i) != ' ') {
                result += once.charAt(i);
            }
        }
        return result;

    }

}
