package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import org.apache.commons.collections.CollectionUtils;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/**
 * @author wzq
 */
public class DataEntryTaskUtils {

    public static List<ImportBatchRecord> processImportBatchRecord(DataEntryTask dataEntryTask, Date createTime) {
        if (null == dataEntryTask || CollectionUtils.isEmpty(dataEntryTask.getBatchInfos())) {
            return Collections.emptyList();
        }
        List<ImportBatchRecord> importBatchRecords = new LinkedList<>();
        dataEntryTask.getBatchInfos().forEach(item -> {
            ImportBatchRecord importBatchRecord = new ImportBatchRecord();
            importBatchRecord.setId(SnowflakeIdWorker.getInstance().newId());
            importBatchRecord.setBatchSeq(item.getBatchNum());
            importBatchRecord.setPId(dataEntryTask.getMasterId());
            importBatchRecord.setHandleFlag(0);
            importBatchRecord.setCreateTime(createTime);
            importBatchRecord.setUpdateTime(createTime);
            importBatchRecords.add(importBatchRecord);
        });
        return importBatchRecords;
    }
}
