package com.digiwin.athena.abt.application.utils;

import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;


@PropertySource(value = { "classpath:i18n/messages*.properties" })
public class MessageUtil {

    /** 将国际化信息存放在一个map中 */
    private static final Map<String, ResourceBundle> MESSAGES = new HashMap<String, ResourceBundle>();

    /** 获取国际化信息 */
    public static String getMessage(String key, Object... params) {
        //获取语言，这个语言是从header中的Accept-Language中获取的，
        //会根据Accept-Language的值生成符合规则的locale，如zh、pt、en等
        String locale1 = null;
        ServletRequestAttributes servletRequestAttributes =  (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if(servletRequestAttributes == null){
            locale1 = "zh_CN";
        }else{
            HttpServletRequest request = servletRequestAttributes.getRequest();
            locale1 = request == null ? "zh_CN" : request.getHeader("locale");
            if (StringUtils.isEmpty(locale1)) {
                locale1 = "zh_CN";
            }
        }

        return getMessageByLocale(key,locale1,params);
    }

    public static String getMessageByLocale(String key, String locale1, Object... params) {
        String[] s = locale1.split("_");
        Locale locale = new Locale(s[0], s[1]);
        ResourceBundle message = MESSAGES.get(locale.toString());
        if (message == null) {
            synchronized (MESSAGES) {
                //在这里读取配置信息
                message = MESSAGES.get(locale.toString());
                if (message == null) {
                    //注1
                    message = ResourceBundle.getBundle("i18n/messages", locale);
                    MESSAGES.put(locale.toString(), message);
                }
            }
        }
        //此处获取并返回message
        if (params != null) {
            try {
                if (locale1.equals("zh_CN")) {
                    return String.format(new String(message.getString(key).getBytes("UTF-8"), "UTF-8"), params);
                } else {
                    return String.format(message.getString(key), params);
                }
            } catch (UnsupportedEncodingException e) {
                return "";
            }
        }
        try {
            if (locale1.equals("zh_CN")) {
                return new String(message.getString(key).getBytes("UTF-8"), "UTF-8");
            } else {
                return String.format(message.getString(key), params);
            }
        } catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(getMessageByLocale("basedata.nofile", "zh_CN"));
        System.out.println(getMessageByLocale("basedata.nofile", "zh_TW"));
        String[] s = "zh_CN".split("_");
        Locale locale = new Locale(s[0], s[1]);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("i18n/message", locale);
        System.out.println(resourceBundle.getString("basedata.nofile"));
        System.out.println(new String(resourceBundle.getString("basedata.nofile").getBytes("UTF-8"), "UTF-8"));
        String[] s1 = "zh_TW".split("_");
        Locale locale1 = new Locale(s1[0], s1[1]);
        ResourceBundle resourceBundle1 = ResourceBundle.getBundle("i18n/message", locale1);
        System.out.println(resourceBundle1.getString("basedata.nofile"));
        System.out.println(new String(resourceBundle1.getString("basedata.nofile").getBytes("UTF-8"), "UTF-8"));

    }

    /** 清除国际化信息 */
    public static void flushMessage() {
        MESSAGES.clear();
    }
}