package com.digiwin.athena.abt.application.utils;

import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import org.springframework.util.StringUtils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

/**
 * @ClassName NetUtil
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/9/22 14:45
 * @Version 1.0
 **/
public class NetUtil {

    private static String localMac;

    public static String getLocalMac() {
        if (!StringUtils.isEmpty(localMac)) {
            return localMac;
        }
        InetAddress ia = null;
        try {
            ia = InetAddress.getLocalHost();
        } catch (UnknownHostException e) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0069.getErrCode(),MessageUtil.getMessage("delivery.getInetError"));
        }
        //获取网卡，获取地址
        byte[] mac;
        try {
            mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        } catch (SocketException e) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0070.getErrCode(),MessageUtil.getMessage("delivery.getMacError"));
        }
        StringBuffer sb = new StringBuffer("");
        if (mac == null){
            return "";
        }
        for(int i=0; i<mac.length; i++) {
            if(i!=0) {
                sb.append("-");
            }
            //字节转换为整数
            int temp = mac[i]&0xff;
            String str = Integer.toHexString(temp);
            if(str.length()==1) {
                sb.append("0"+str);
            }else {
                sb.append(str);
            }
        }
        localMac = sb.toString().toUpperCase();
        return localMac;
    }

}
