package com.digiwin.athena.abt.event.job;

import com.digiwin.athena.abt.application.dto.migration.abt.summary.CardJobData;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.CardTaskContext;
import com.digiwin.athena.abt.application.service.abt.migration.summary.RefreshCardMessageService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.TenantService;
import com.digiwin.athena.abt.application.utils.AppAuthContextUtils;
import com.digiwin.athena.abt.core.meta.constants.JobConstants;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.quartz.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
@Slf4j
@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class RefreshCardJob implements Job {

    @Resource
    private RefreshCardMessageService refreshCardMessageService;
    @Resource
    private TenantService tenantService;


    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info("定时任务开始执行");
        try {
            JobDetail jobDetail = jobExecutionContext.getJobDetail();
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            Set<CardJobData> cardData = (Set<CardJobData>) jobDataMap.get(JobConstants.JOB_DATA_KEY);
            log.info("任务执行数据:{}", JsonUtils.objectToString(cardData));
            // 记录每个id对应的错误数量
            if(CollectionUtils.isNotEmpty(cardData)){
                Map<String,Map<Long,Integer>> idErrorCount = Maps.newHashMapWithExpectedSize(2);
                // 根据租户 code 卡片类型分组
                Map<String, Map<String, Map<String, List<CardJobData>>>> groupMap = cardData.stream().collect(Collectors.groupingBy(CardJobData::getTenantId, Collectors.groupingBy(CardJobData::getPagCode, Collectors.groupingBy(CardJobData::getCode))));
                groupMap.forEach((tenantId,v)->{
                    JSONObject apiResult = tenantService.queryApiVirtualToken(tenantId);
                    String virtualToken = apiResult.getString("token");
                    //将token放入线程内
                    AuthoredUser authoredUser = AppAuthContextUtils.setAuthoredUserContext(virtualToken);
                    authoredUser.setTenantId(apiResult.getString("tenantId"));
                    CardTaskContext cardTaskContext = new CardTaskContext(authoredUser,jobDataMap.getInt("partition_size"), jobDataMap.getInt("singleTaskSize"), jobDataMap.getInt("batchTaskSize"),jobDataMap.getInt("max_error_size"));
                    v.forEach((pageCode,v1)->{
                        v1.forEach((code,v2)->{
                            CardJobData cardJobData = v2.get(0);
                            refreshCardMessageService.refreshTaskCard(cardTaskContext,cardJobData);
                        });
                    });
                    idErrorCount.putAll(cardTaskContext.getIdErrorCount());
                });
                Object errorCount = jobDataMap.get("id_error_count");
                if(errorCount != null){
                    // 上一个任务的错误数量
                    Map<String,Map<Long,Integer>> prevIdErrorCount = (Map<String, Map<Long, Integer>>) errorCount;
                    // 添加每个id对应的次数
                    idErrorCount.forEach((k,v)->{
                        Map<Long, Integer> idErrorMap = prevIdErrorCount.get(k);
                        if(idErrorMap != null){
                            for (Map.Entry<Long,Integer> entry:v.entrySet()){
                                Long key = entry.getKey();
                                Integer num = idErrorMap.get(key);
                                if(num != null){
                                    v.put(key,entry.getValue()+num);
                                }
                            }
                        }
                    });
                    jobDataMap.put("id_error_count",idErrorCount);
                }
            }
        }catch (Exception e){
            log.info("定时任务执行报错:{}",e.getMessage());
        }
    }
}

