/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.configuration;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
public class BkMongoTemplateConfig {
    @Value(value="${spring.data.mongodb.uri}")
    private String uriLog;
    @Value(value="${spring.data.mongodb.atmcBkDatabase}")
    private String atmcBkDatabase;
    @Value(value="${spring.data.mongodb.atmcCardBusinessMessage:atmc_card_business_message}")
    private String atmcCardBusinessMessage;
    @Value(value="${spring.data.mongodb.atmcTempData}")
    private String atmcTempData;

    @Bean(value={"atmcBkDatabaseMongoTemplate"})
    @ConditionalOnMissingBean(name={"atmcBkDatabaseMongoTemplate"})
    public MongoTemplate atmcBkDatabaseMongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriLog)).build(), null);
        return new MongoTemplate((MongoClient)client, this.atmcBkDatabase);
    }

    @Bean(value={"atmcCardBusinessMessageMongoTemplate"})
    @ConditionalOnMissingBean(name={"atmcCardBusinessMessageMongoTemplate"})
    public MongoTemplate atmcCardBusinessMessageMongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriLog)).build(), null);
        return new MongoTemplate((MongoClient)client, this.atmcCardBusinessMessage);
    }

    @Bean(value={"atmcTempDataMongo"})
    @ConditionalOnMissingBean(name={"atmcTempDataMongo"})
    public MongoTemplate atmcTempDataMongo() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriLog)).build(), null);
        return new MongoTemplate((MongoClient)client, this.atmcTempData);
    }
}

