/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.configuration;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.digiwin.athena.abt.application.configuration.AbtEntityMetaObjectHandler;
import com.digiwin.athena.abt.application.configuration.AbtInsertBatchSqlInjector;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.quartz.QuartzDataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

@Configuration
@MapperScan(basePackages={"com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc"}, sqlSessionFactoryRef="businessSqlSessionFactory", markerInterface=BaseMapper.class)
public class DataSourceConfig {
    private static final String DATASOURCE_NAME = "dbDataSource";
    private static final String BUSINESS_DATASOURCE_PREFIX = "spring.datasource.druid.business";
    private static final String QUARTZ_DATASOURCE_PREFIX = "spring.datasource.druid.quartz";

    @Primary
    @Bean(name={"dbDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.druid.business")
    public DruidDataSource druidDataSource() {
        return new DruidDataSource();
    }

    @Primary
    @Bean(name={"businessSqlSessionFactory"})
    public SqlSessionFactory businessSqlSessionFactory(@Qualifier(value="dbDataSource") DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/*.xml"));
        GlobalConfig globalConfig = GlobalConfigUtils.defaults();
        globalConfig.setBanner(false);
        globalConfig.setSqlInjector((ISqlInjector)new AbtInsertBatchSqlInjector());
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new AbtEntityMetaObjectHandler());
        bean.setGlobalConfig(globalConfig);
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor(DbType.MYSQL);
        paginationInnerInterceptor.setMaxLimit(Long.valueOf(2000L));
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
        bean.setPlugins(new Interceptor[]{interceptor});
        return bean.getObject();
    }

    @Primary
    @Bean(name={"businessSqlSessionTemplate"})
    public SqlSessionTemplate importStatisticsSqlSessionTemplate(@Qualifier(value="businessSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean(name={"abtQzDataSource"})
    @QuartzDataSource
    @ConfigurationProperties(prefix="spring.datasource.druid.quartz")
    public DataSource quartzDataSource() {
        return new DruidDataSource();
    }

    @Bean
    public SchedulerFactoryBean schedulerFactoryBean(@QuartzDataSource DataSource abtQzDataSource) {
        SchedulerFactoryBean factory = new SchedulerFactoryBean();
        factory.setDataSource(abtQzDataSource);
        factory.setJobFactory((JobFactory)new SpringBeanJobFactory());
        return factory;
    }
}

