/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.configuration;

import com.digiwin.athena.abt.application.service.abt.migration.mq.ConfirmCallbackService;
import com.digiwin.athena.abt.application.utils.NetUtil;
import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DirectRabbitConfig {
    public static final String QUEUE_NAME = "AbtImportDataEntryQueue-" + NetUtil.getLocalMac();
    public static final String EXCHANGE_NAME = "AbtImportDataEntryExchange";
    public static final String ROUTING_NAME = NetUtil.getLocalMac();
    public static final String DEAD_LETTER_EXCHANGE_NAME = "AbtImportDataEntryDeadLetterExchange";
    public static final String DEAD_LETTER_QUEUE_NAME = "AbtImportDataEntryDeadLetterQueue-" + NetUtil.getLocalMac();
    public static final String DEAD_LETTER_ROUTING_NAME = NetUtil.getLocalMac();
    public static final String MANUAL_DEAD_LETTER_EXCHANGE_NAME = "AbtImportManualDataEntryDeadLetterExchange";
    public static final String MANUAL_DEAD_LETTER_QUEUE_NAME = "AbtImportManualDataEntryDeadLetterQueue";
    public static final String MANUAL_DEAD_LETTER_ROUTING_NAME = "Manual";
    public static final String ERROR_TABLE_EXCHANGE_NAME = "AbtImportErrorTableExchange";
    public static final String EXPORT_FILE_QUEUE_NAME = "AbtExportFileQueue-" + NetUtil.getLocalMac();
    public static final String EXPORT_FILE_EXCHANGE_NAME = "AbtExportFileExchange";
    public static final String EXPORT_HISTORY_DATA_FILE_QUEUE_NAME = "AbtExportHistoryDataFileQueue-" + NetUtil.getLocalMac();
    public static final String EXPORT_HISTORY_DATA_FILE_EXCHANGE_NAME = "AbtExportHistoryDataFileExchange";
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_QUEUE_NAME = "AbtExportHistoryProjectTaskDetailQueue-" + NetUtil.getLocalMac();
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_EXCHANGE_NAME = "AbtExportHistoryProjectTaskDetailExchange";
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_ROUTING_KEY = "AbtExportHistoryProjectTaskDetailRoutingKey" + NetUtil.getLocalMac();
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_EXCHANGE_NAME = "AbtExportHistoryProjectTaskDetailDeadLetterExchange";
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_QUEUE_NAME = "AbtExportHistoryProjectTaskDetailDeadLetterQueue-" + NetUtil.getLocalMac();
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_ROUTING_KEY = "ExportHistoryProjectTaskDetailDeadLetterRoutingKey" + NetUtil.getLocalMac();
    public static final String IMPORT_FILE_QUEUE_NAME = "AsyncImportFileQueue-" + NetUtil.getLocalMac();
    public static final String IMPORT_FILE_EXCHANGE_NAME = "AsyncImportFileExchange";

    @Bean
    public String dataEntryQueueNameAsync() {
        return IMPORT_FILE_QUEUE_NAME;
    }

    @Bean
    public DirectExchange createAsyncDirectExchange() {
        return new DirectExchange(IMPORT_FILE_EXCHANGE_NAME, true, false);
    }

    @Bean
    public Queue createAsyncDirectQueue() {
        HashMap<String, Integer> args = new HashMap<String, Integer>(6);
        args.put("x-message-ttl", 120000);
        args.put("x-expires", 360000);
        return new Queue(IMPORT_FILE_QUEUE_NAME, true, false, false, args);
    }

    @Bean
    public Binding bindingAsyncDataEntryDirect(@Qualifier(value="createAsyncDirectQueue") Queue queue, @Qualifier(value="createAsyncDirectExchange") DirectExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with(ROUTING_NAME);
    }

    @Bean
    public String dataEntryQueueName() {
        return QUEUE_NAME;
    }

    @Bean
    public DirectExchange createDirectExchange() {
        return new DirectExchange(EXCHANGE_NAME, true, false);
    }

    @Bean
    public Queue createDirectQueue() {
        HashMap<String, Object> args = new HashMap<String, Object>(6);
        args.put("x-dead-letter-exchange", DEAD_LETTER_EXCHANGE_NAME);
        args.put("x-dead-letter-routing-key", DEAD_LETTER_ROUTING_NAME);
        args.put("x-message-ttl", 120000);
        args.put("x-expires", 360000);
        return new Queue(QUEUE_NAME, true, false, false, args);
    }

    @Bean
    public Binding bindingDataEntryDirect(@Qualifier(value="createDirectQueue") Queue queue, @Qualifier(value="createDirectExchange") DirectExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with(ROUTING_NAME);
    }

    @Bean
    public String exportFileQueueName() {
        return EXPORT_FILE_QUEUE_NAME;
    }

    @Bean
    public DirectExchange createExportFileExchange() {
        return new DirectExchange(EXPORT_FILE_EXCHANGE_NAME, true, false);
    }

    @Bean
    public Queue createExportFileQueue() {
        HashMap<String, Integer> args = new HashMap<String, Integer>(6);
        args.put("x-message-ttl", 120000);
        args.put("x-expires", 360000);
        return new Queue(EXPORT_FILE_QUEUE_NAME, true, false, false, args);
    }

    @Bean
    public Binding bindingExportFileDirect(@Qualifier(value="createExportFileQueue") Queue queue, @Qualifier(value="createExportFileExchange") DirectExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with(ROUTING_NAME);
    }

    @Bean
    public String exportHistoryDataFileQueueName() {
        return EXPORT_HISTORY_DATA_FILE_QUEUE_NAME;
    }

    @Bean
    public DirectExchange createExportHistoryDataFileExchange() {
        return new DirectExchange(EXPORT_HISTORY_DATA_FILE_EXCHANGE_NAME, true, false);
    }

    @Bean
    public Queue createExportHistoryDataFileQueue() {
        HashMap<String, Integer> args = new HashMap<String, Integer>(6);
        args.put("x-message-ttl", 120000);
        args.put("x-expires", 360000);
        return new Queue(EXPORT_HISTORY_DATA_FILE_QUEUE_NAME, true, false, false, args);
    }

    @Bean
    public Binding bindingExportHistoryDataFileDirect(@Qualifier(value="createExportHistoryDataFileQueue") Queue queue, @Qualifier(value="createExportHistoryDataFileExchange") DirectExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with(ROUTING_NAME);
    }

    @Bean
    public String dataEntryDeadLetterQueueName() {
        return DEAD_LETTER_QUEUE_NAME;
    }

    @Bean
    public DirectExchange dataEntryDeadLetterExchange() {
        return new DirectExchange(DEAD_LETTER_EXCHANGE_NAME);
    }

    @Bean
    public Queue dataEntryDeadLetterQueue() {
        HashMap<String, Object> args = new HashMap<String, Object>(6);
        args.put("x-dead-letter-exchange", MANUAL_DEAD_LETTER_EXCHANGE_NAME);
        args.put("x-dead-letter-routing-key", MANUAL_DEAD_LETTER_ROUTING_NAME);
        args.put("x-message-ttl", 240000);
        args.put("x-expires", 360000);
        return new Queue(DEAD_LETTER_QUEUE_NAME, true, false, false, args);
    }

    @Bean
    public Binding bindingDataEntryDeadLetterDirect(@Qualifier(value="dataEntryDeadLetterQueue") Queue queue, @Qualifier(value="dataEntryDeadLetterExchange") DirectExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with(DEAD_LETTER_ROUTING_NAME);
    }

    @Bean
    public Queue manualDataEntryDeadLetterQueue() {
        return new Queue(MANUAL_DEAD_LETTER_QUEUE_NAME);
    }

    @Bean
    public DirectExchange manualDataEntryDeadLetterExchange() {
        return new DirectExchange(MANUAL_DEAD_LETTER_EXCHANGE_NAME);
    }

    @Bean
    public Binding bindingManualDataEntryDeadLetterDirect(@Qualifier(value="manualDataEntryDeadLetterQueue") Queue queue, @Qualifier(value="manualDataEntryDeadLetterExchange") DirectExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with(MANUAL_DEAD_LETTER_ROUTING_NAME);
    }

    @Bean
    public DirectExchange createErrorTableExchange() {
        return new DirectExchange(ERROR_TABLE_EXCHANGE_NAME, true, false);
    }

    @Bean
    public ConfirmCallbackService confirmCallbackService() {
        return new ConfirmCallbackService();
    }

    @Bean
    public String exportHistoryProjectTaskDetailQueueName() {
        return EXPORT_HISTORY_PROJECT_TASK_DETAIL_QUEUE_NAME;
    }

    @Bean
    public DirectExchange createExportHistoryProjectTaskDetailExchange() {
        return new DirectExchange(EXPORT_HISTORY_PROJECT_TASK_DETAIL_EXCHANGE_NAME, true, false);
    }

    @Bean
    public Queue createExportHistoryProjectTaskDetailQueue() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("x-message-ttl", 3600000);
        args.put("x-expires", 0x6DDD00);
        args.put("x-dead-letter-exchange", EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_EXCHANGE_NAME);
        args.put("x-dead-letter-routing-key", EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_ROUTING_KEY);
        return new Queue(EXPORT_HISTORY_PROJECT_TASK_DETAIL_QUEUE_NAME, true, false, false, args);
    }

    @Bean
    public Binding bindingExportHistoryProjectTaskDataFileDirect(@Qualifier(value="createExportHistoryProjectTaskDetailQueue") Queue queue, @Qualifier(value="createExportHistoryProjectTaskDetailExchange") DirectExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with(EXPORT_HISTORY_PROJECT_TASK_DETAIL_ROUTING_KEY);
    }

    @Bean
    public String exportHistoryProjectTaskDetailDeadLetterQueueName() {
        return EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_QUEUE_NAME;
    }

    @Bean
    public DirectExchange exportHistoryProjectTaskDetailDeadLetterExchange() {
        return new DirectExchange(EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_EXCHANGE_NAME);
    }

    @Bean
    public Queue exportHistoryProjectTaskDetailDeadLetterQueue() {
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("x-message-ttl", 1800000);
        args.put("x-expires", 3600000);
        return new Queue(EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_QUEUE_NAME, true, false, false, args);
    }

    @Bean
    public Binding bindingExportHistoryProjectTaskDetailDeadLetterDirect(@Qualifier(value="exportHistoryProjectTaskDetailDeadLetterQueue") Queue queue, @Qualifier(value="exportHistoryProjectTaskDetailDeadLetterExchange") DirectExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with(EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_ROUTING_KEY);
    }
}

