/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.configuration;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@MapperScan(basePackages={"com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt"}, sqlSessionFactoryRef="importStatisticsSqlSessionFactory", markerInterface=BaseMapper.class)
public class ImportStatisticsDataSourceConfig {
    private static final String DATASOURCE_NAME = "importStatisticsDataSource";
    private static final String IMPORT_DATASOURCE_PREFIX = "spring.datasource.druid.import";

    @Bean(name={"importStatisticsDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.druid.import")
    public DruidDataSource importStatisticsDataSource() {
        return new DruidDataSource();
    }

    @Bean(name={"importStatisticsSqlSessionFactory"})
    public SqlSessionFactory importStatisticsSqlSessionFactory(@Qualifier(value="importStatisticsDataSource") DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/importstatistics/*.xml"));
        return bean.getObject();
    }

    @Bean
    DataSourceTransactionManager transactionManager(Environment environment, @Qualifier(value="importStatisticsDataSource") DataSource dataSource, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        DataSourceTransactionManager transactionManager = this.createTransactionManager(environment, dataSource);
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((PlatformTransactionManager)transactionManager));
        return transactionManager;
    }

    private DataSourceTransactionManager createTransactionManager(Environment environment, @Qualifier(value="importStatisticsDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"importStatisticsSqlSessionTemplate"})
    public SqlSessionTemplate importStatisticsSqlSessionTemplate(@Qualifier(value="importStatisticsSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

