/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.configuration;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RemoteProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteProperties.class);
    @Value(value="${themeMap.domainUri:}")
    private String webThemeMapDomainUri;
    @Value(value="${rabbit.mquri:}")
    private String rabbitMqUri;
    @Value(value="${esp.uri:}")
    private String espUri;
    @Value(value="${mdc.uri:}")
    private String mdcUri;
    @Value(value="${eoc.uri:}")
    private String eocUri;
    @Value(value="${dap.lmcUri:}")
    private String dapLmcUri;
    private String host;
    private String ipAddress;
    private long freeMemory;
    private long totalMemory;
    private long maxMemory;
    private String osName;
    private long pid;
    private LocalDateTime startTime;
    private long runtime;
    private int threadCount;

    public void refresh() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        this.setFreeMemory(RemoteProperties.byteToM(freeMemory));
        long totalMemory = runtime.totalMemory();
        this.setTotalMemory(RemoteProperties.byteToM(totalMemory));
        long maxMemory = runtime.maxMemory();
        this.setMaxMemory(RemoteProperties.byteToM(maxMemory));
        this.setOsName(System.getProperty("os.name"));
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            this.setHost(hostName);
            if (this.ipAddress == null) {
                this.ipAddress = localHost.getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            log.error("UnknownHostException:{}", (Object)e.getMessage());
            this.setHost("\u672a\u77e5");
        }
        this.setIpAddress(this.ipAddress);
        long startTime = runtimeMXBean.getStartTime();
        LocalDateTime startDate = LocalDateTime.ofEpochSecond(startTime / 1000L, 0, ZoneOffset.ofHours(0));
        this.setStartTime(startDate);
        this.setRuntime(runtimeMXBean.getUptime());
        this.setThreadCount(ManagementFactory.getThreadMXBean().getThreadCount());
        this.setPid(RemoteProperties.tryGetPid());
    }

    static long byteToM(long bytes) {
        long kb = bytes / 1024L / 1024L;
        return kb;
    }

    static long tryGetPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String pid = name.split("@")[0];
            return Long.parseLong(pid);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Generated
    public RemoteProperties() {
    }

    @Generated
    public String getWebThemeMapDomainUri() {
        return this.webThemeMapDomainUri;
    }

    @Generated
    public String getRabbitMqUri() {
        return this.rabbitMqUri;
    }

    @Generated
    public String getEspUri() {
        return this.espUri;
    }

    @Generated
    public String getMdcUri() {
        return this.mdcUri;
    }

    @Generated
    public String getEocUri() {
        return this.eocUri;
    }

    @Generated
    public String getDapLmcUri() {
        return this.dapLmcUri;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public long getFreeMemory() {
        return this.freeMemory;
    }

    @Generated
    public long getTotalMemory() {
        return this.totalMemory;
    }

    @Generated
    public long getMaxMemory() {
        return this.maxMemory;
    }

    @Generated
    public String getOsName() {
        return this.osName;
    }

    @Generated
    public long getPid() {
        return this.pid;
    }

    @Generated
    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getRuntime() {
        return this.runtime;
    }

    @Generated
    public int getThreadCount() {
        return this.threadCount;
    }

    @Generated
    public void setWebThemeMapDomainUri(String webThemeMapDomainUri) {
        this.webThemeMapDomainUri = webThemeMapDomainUri;
    }

    @Generated
    public void setRabbitMqUri(String rabbitMqUri) {
        this.rabbitMqUri = rabbitMqUri;
    }

    @Generated
    public void setEspUri(String espUri) {
        this.espUri = espUri;
    }

    @Generated
    public void setMdcUri(String mdcUri) {
        this.mdcUri = mdcUri;
    }

    @Generated
    public void setEocUri(String eocUri) {
        this.eocUri = eocUri;
    }

    @Generated
    public void setDapLmcUri(String dapLmcUri) {
        this.dapLmcUri = dapLmcUri;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    @Generated
    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    @Generated
    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    @Generated
    public void setOsName(String osName) {
        this.osName = osName;
    }

    @Generated
    public void setPid(long pid) {
        this.pid = pid;
    }

    @Generated
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    @Generated
    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteProperties)) {
            return false;
        }
        RemoteProperties other = (RemoteProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFreeMemory() != other.getFreeMemory()) {
            return false;
        }
        if (this.getTotalMemory() != other.getTotalMemory()) {
            return false;
        }
        if (this.getMaxMemory() != other.getMaxMemory()) {
            return false;
        }
        if (this.getPid() != other.getPid()) {
            return false;
        }
        if (this.getRuntime() != other.getRuntime()) {
            return false;
        }
        if (this.getThreadCount() != other.getThreadCount()) {
            return false;
        }
        String this$webThemeMapDomainUri = this.getWebThemeMapDomainUri();
        String other$webThemeMapDomainUri = other.getWebThemeMapDomainUri();
        if (this$webThemeMapDomainUri == null ? other$webThemeMapDomainUri != null : !this$webThemeMapDomainUri.equals(other$webThemeMapDomainUri)) {
            return false;
        }
        String this$rabbitMqUri = this.getRabbitMqUri();
        String other$rabbitMqUri = other.getRabbitMqUri();
        if (this$rabbitMqUri == null ? other$rabbitMqUri != null : !this$rabbitMqUri.equals(other$rabbitMqUri)) {
            return false;
        }
        String this$espUri = this.getEspUri();
        String other$espUri = other.getEspUri();
        if (this$espUri == null ? other$espUri != null : !this$espUri.equals(other$espUri)) {
            return false;
        }
        String this$mdcUri = this.getMdcUri();
        String other$mdcUri = other.getMdcUri();
        if (this$mdcUri == null ? other$mdcUri != null : !this$mdcUri.equals(other$mdcUri)) {
            return false;
        }
        String this$eocUri = this.getEocUri();
        String other$eocUri = other.getEocUri();
        if (this$eocUri == null ? other$eocUri != null : !this$eocUri.equals(other$eocUri)) {
            return false;
        }
        String this$dapLmcUri = this.getDapLmcUri();
        String other$dapLmcUri = other.getDapLmcUri();
        if (this$dapLmcUri == null ? other$dapLmcUri != null : !this$dapLmcUri.equals(other$dapLmcUri)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$osName = this.getOsName();
        String other$osName = other.getOsName();
        if (this$osName == null ? other$osName != null : !this$osName.equals(other$osName)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        return !(this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoteProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $freeMemory = this.getFreeMemory();
        result = result * 59 + (int)($freeMemory >>> 32 ^ $freeMemory);
        long $totalMemory = this.getTotalMemory();
        result = result * 59 + (int)($totalMemory >>> 32 ^ $totalMemory);
        long $maxMemory = this.getMaxMemory();
        result = result * 59 + (int)($maxMemory >>> 32 ^ $maxMemory);
        long $pid = this.getPid();
        result = result * 59 + (int)($pid >>> 32 ^ $pid);
        long $runtime = this.getRuntime();
        result = result * 59 + (int)($runtime >>> 32 ^ $runtime);
        result = result * 59 + this.getThreadCount();
        String $webThemeMapDomainUri = this.getWebThemeMapDomainUri();
        result = result * 59 + ($webThemeMapDomainUri == null ? 43 : $webThemeMapDomainUri.hashCode());
        String $rabbitMqUri = this.getRabbitMqUri();
        result = result * 59 + ($rabbitMqUri == null ? 43 : $rabbitMqUri.hashCode());
        String $espUri = this.getEspUri();
        result = result * 59 + ($espUri == null ? 43 : $espUri.hashCode());
        String $mdcUri = this.getMdcUri();
        result = result * 59 + ($mdcUri == null ? 43 : $mdcUri.hashCode());
        String $eocUri = this.getEocUri();
        result = result * 59 + ($eocUri == null ? 43 : $eocUri.hashCode());
        String $dapLmcUri = this.getDapLmcUri();
        result = result * 59 + ($dapLmcUri == null ? 43 : $dapLmcUri.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $osName = this.getOsName();
        result = result * 59 + ($osName == null ? 43 : $osName.hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RemoteProperties(webThemeMapDomainUri=" + this.getWebThemeMapDomainUri() + ", rabbitMqUri=" + this.getRabbitMqUri() + ", espUri=" + this.getEspUri() + ", mdcUri=" + this.getMdcUri() + ", eocUri=" + this.getEocUri() + ", dapLmcUri=" + this.getDapLmcUri() + ", host=" + this.getHost() + ", ipAddress=" + this.getIpAddress() + ", freeMemory=" + this.getFreeMemory() + ", totalMemory=" + this.getTotalMemory() + ", maxMemory=" + this.getMaxMemory() + ", osName=" + this.getOsName() + ", pid=" + this.getPid() + ", startTime=" + this.getStartTime() + ", runtime=" + this.getRuntime() + ", threadCount=" + this.getThreadCount() + ")";
    }
}

