/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.configuration;

import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import java.net.InetAddress;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.SetParams;

@Configuration
public class SnowflakeIdConfig
implements DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnowflakeIdConfig.class);
    private static final long FIXED_RATE = 300000L;
    private final long expire = 480000L;
    private static final String POSTPONE_EXPIRE = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('PEXPIRE', KEYS[1], ARGV[2]) else return '0' end";
    private static final String DEL_LOCK = "if redis.call('get',KEYS[1]) == ARGV[1] then return redis.call('del',KEYS[1]) else return 0 end";
    private String lockKey = null;
    private String hostAddress = null;
    private static final Long POSTPONE_SUCCESS = 1L;
    private long workerId = 0L;
    private long dataCenterId = 0L;
    @Autowired
    private RedisTemplate redisTemplate;

    @Scheduled(fixedRate=300000L)
    public void lockWorkerId() {
        try {
            if (StringUtils.isBlank((String)this.lockKey)) {
                InetAddress localHost = InetAddress.getLocalHost();
                this.hostAddress = localHost.getHostAddress();
                String key = null;
                for (int j = 1; j < 7; ++j) {
                    for (int i = 1; i < 7; ++i) {
                        key = String.format("abt:Snowflake:WorkerId:%s:%s", i, j);
                        if (!this.exePostpone(key, this.hostAddress, 480000L) && !this.lockWorkerId(key, this.hostAddress)) continue;
                        this.workerId = i;
                        this.dataCenterId = j;
                        this.lockKey = key;
                        SnowflakeIdWorker.getInstance().init(this.dataCenterId, this.workerId);
                        log.warn("[SnowflakeIdConfig] lockKey:{}", (Object)this.lockKey);
                        break;
                    }
                    if (this.dataCenterId != 0L) break;
                }
                if (this.dataCenterId == 0L || this.workerId == 0L) {
                    System.exit(1);
                }
            } else {
                this.exePostpone(this.lockKey, this.hostAddress, this.expire);
            }
        }
        catch (Exception e) {
            log.warn("[SnowflakeIdConfig] error:{}", (Throwable)e);
        }
    }

    private boolean exePostpone(String key, String value, long expire) {
        Boolean isOK = Boolean.FALSE;
        try {
            isOK = (Boolean)this.redisTemplate.execute(redisConnection -> {
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(key);
                ArrayList<String> params = new ArrayList<String>();
                params.add(value);
                params.add(String.valueOf(expire));
                Jedis jedis = (Jedis)redisConnection.getNativeConnection();
                Object result = jedis.eval(POSTPONE_EXPIRE, keys, params);
                if (POSTPONE_SUCCESS.equals(result)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            });
        }
        catch (Exception e) {
            log.warn("[SnowflakeIdConfig] postPone error:{}", (Throwable)e);
        }
        return Boolean.TRUE.equals(isOK);
    }

    private boolean lockWorkerId(String key, String value) {
        Boolean locked = (Boolean)this.redisTemplate.execute(redisConnection -> {
            SetParams setParams;
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            String result = jedis.set(key, value, setParams = new SetParams().nx().px(480000L));
            if ("OK".equals(result)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
        return Boolean.TRUE.equals(locked);
    }

    public void destroy() throws Exception {
        try {
            this.redisTemplate.execute(redisConnection -> {
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(this.lockKey);
                ArrayList<String> params = new ArrayList<String>();
                params.add(this.hostAddress);
                params.add(String.valueOf(480000L));
                Jedis jedis = (Jedis)redisConnection.getNativeConnection();
                Object result = jedis.eval(DEL_LOCK, keys, params);
                return Boolean.TRUE;
            });
        }
        catch (Exception e) {
            log.warn("[SnowflakeIdConfig] del error:{}", (Throwable)e);
        }
    }
}

