/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.configuration;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ThreadPoolConfig {
    @Value(value="${threadPool.refreshCard.corePoolSize:5}")
    private int corePoolSize;
    @Value(value="${threadPool.refreshCard.maxPoolSize:10}")
    private int maxPoolSize;
    @Value(value="${threadPool.refreshCard.queueCapacity:200}")
    private int queueCapacity;
    @Value(value="${threadPool.refreshCard.queueCapacity:300}")
    private int keepAliveSeconds;

    @Bean(name={"threadPoolRefreshCardTaskExecutor"})
    public ThreadPoolTaskExecutor threadPoolRefreshCardTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(this.maxPoolSize);
        executor.setCorePoolSize(this.corePoolSize);
        executor.setQueueCapacity(this.queueCapacity);
        executor.setKeepAliveSeconds(this.keepAliveSeconds);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }
}

