/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.dto.migration.abt.event;

import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ImportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.PersonalCenterMessage;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.WebSocketMessage;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.MessageReceiver;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;

public class MessageFactory {
    public static final String MESSAGE_TYPE = "baseDataEntry";
    private static final String SOURCE = "athena";

    public static WebSocketMessage produceWsMsgByImportSuccessEvent(ImportSuccessEvent event) {
        WebSocketMessage webSocketMessage = new WebSocketMessage();
        webSocketMessage.setSource(SOURCE);
        webSocketMessage.setTitle("Title");
        webSocketMessage.setPush(true);
        webSocketMessage.setType(MESSAGE_TYPE);
        webSocketMessage.setSubType("");
        webSocketMessage.setContent(event);
        MessageReceiver messageReceiver = (MessageReceiver)JsonUtils.jsonToObject((String)event.getUserJson(), MessageReceiver.class);
        ArrayList<MessageReceiver> messageReceiverList = new ArrayList<MessageReceiver>();
        messageReceiverList.add(messageReceiver);
        webSocketMessage.setReceivers(messageReceiverList);
        return webSocketMessage;
    }

    public static PersonalCenterMessage producePcMsgByImportSuccessEvent(ImportSuccessEvent event) {
        PersonalCenterMessage personalCenterMessage = new PersonalCenterMessage();
        MessageReceiver messageReceiver = (MessageReceiver)JsonUtils.jsonToObject((String)event.getUserJson(), MessageReceiver.class);
        personalCenterMessage.setUserId(messageReceiver.getUserId());
        personalCenterMessage.setTenantId(messageReceiver.getTenantId());
        personalCenterMessage.setSource(SOURCE);
        personalCenterMessage.setLangName("");
        personalCenterMessage.setTitle("");
        personalCenterMessage.setType(MESSAGE_TYPE);
        personalCenterMessage.setSubType("Import");
        personalCenterMessage.setSubTypeCategory("ATHENA_REMIND");
        if (event.getFailedNum() == 0) {
            personalCenterMessage.setCategory("OTHER");
        } else {
            personalCenterMessage.setCategory("EXCEPTION");
        }
        personalCenterMessage.setImportance(1);
        personalCenterMessage.setState(0);
        personalCenterMessage.setSendDate(LocalDateTime.now());
        personalCenterMessage.setContent(event);
        return personalCenterMessage;
    }

    public static PersonalCenterMessage producePcMsgByExportSuccessEvent(ExportSuccessEvent event) {
        PersonalCenterMessage personalCenterMessage = new PersonalCenterMessage();
        MessageReceiver messageReceiver = (MessageReceiver)JsonUtils.jsonToObject((String)event.getUserJson(), MessageReceiver.class);
        personalCenterMessage.setUserId(messageReceiver.getUserId());
        personalCenterMessage.setTenantId(messageReceiver.getTenantId());
        personalCenterMessage.setSource(SOURCE);
        personalCenterMessage.setLangName("");
        personalCenterMessage.setTitle("");
        personalCenterMessage.setType(MESSAGE_TYPE);
        personalCenterMessage.setSubType("Export");
        personalCenterMessage.setSubTypeCategory("ATHENA_REMIND");
        if (ImportAndExportStatisticsConstants.EXPROT_STATE_SUCCESS.equals(event.getState())) {
            personalCenterMessage.setCategory("OTHER");
        } else {
            personalCenterMessage.setCategory("EXCEPTION");
        }
        personalCenterMessage.setImportance(1);
        personalCenterMessage.setState(0);
        personalCenterMessage.setSendDate(LocalDateTime.now());
        personalCenterMessage.setContent(event);
        return personalCenterMessage;
    }
}

