/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.dto.migration.abt.summary;

import com.digiwin.athena.abt.application.dto.migration.atmc.agile.CardDataParam;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CardTaskContext {
    private List<CardDataParam> singleTasks;
    private List<CardDataParam> batchTasks;
    private AuthoredUser authoredUser;
    private int partitionSize;
    private int singleTaskSize;
    private int batchTaskSize;
    private int maxErrorSize;
    private Map<String, Map<Long, Integer>> idErrorCount;

    public CardTaskContext(AuthoredUser authoredUser, int partitionSize, int singleTaskSize, int batchTaskSize, int maxErrorSize) {
        this.authoredUser = authoredUser;
        this.singleTasks = Lists.newLinkedList();
        this.batchTasks = Lists.newLinkedList();
        this.partitionSize = partitionSize;
        this.singleTaskSize = singleTaskSize;
        this.batchTaskSize = batchTaskSize;
        this.maxErrorSize = maxErrorSize;
        this.idErrorCount = Maps.newHashMapWithExpectedSize((int)2);
    }

    public List<CardDataParam> getTask(boolean isBatch) {
        return isBatch ? this.batchTasks : this.singleTasks;
    }

    public void addTask(CardDataParam cardDataParam, boolean flag) {
        this.getTask(flag).add(cardDataParam);
    }

    public void recordIdError(String pageCode, List<Long> ids) {
        Map idToErrorMap = this.idErrorCount.computeIfAbsent(pageCode, e -> new HashMap());
        for (Long id : ids) {
            Integer num = idToErrorMap.computeIfAbsent(id, k -> 0);
            idToErrorMap.put(id, num);
        }
    }

    @Generated
    public List<CardDataParam> getSingleTasks() {
        return this.singleTasks;
    }

    @Generated
    public List<CardDataParam> getBatchTasks() {
        return this.batchTasks;
    }

    @Generated
    public AuthoredUser getAuthoredUser() {
        return this.authoredUser;
    }

    @Generated
    public int getPartitionSize() {
        return this.partitionSize;
    }

    @Generated
    public int getSingleTaskSize() {
        return this.singleTaskSize;
    }

    @Generated
    public int getBatchTaskSize() {
        return this.batchTaskSize;
    }

    @Generated
    public int getMaxErrorSize() {
        return this.maxErrorSize;
    }

    @Generated
    public Map<String, Map<Long, Integer>> getIdErrorCount() {
        return this.idErrorCount;
    }

    @Generated
    public void setSingleTasks(List<CardDataParam> singleTasks) {
        this.singleTasks = singleTasks;
    }

    @Generated
    public void setBatchTasks(List<CardDataParam> batchTasks) {
        this.batchTasks = batchTasks;
    }

    @Generated
    public void setAuthoredUser(AuthoredUser authoredUser) {
        this.authoredUser = authoredUser;
    }

    @Generated
    public void setPartitionSize(int partitionSize) {
        this.partitionSize = partitionSize;
    }

    @Generated
    public void setSingleTaskSize(int singleTaskSize) {
        this.singleTaskSize = singleTaskSize;
    }

    @Generated
    public void setBatchTaskSize(int batchTaskSize) {
        this.batchTaskSize = batchTaskSize;
    }

    @Generated
    public void setMaxErrorSize(int maxErrorSize) {
        this.maxErrorSize = maxErrorSize;
    }

    @Generated
    public void setIdErrorCount(Map<String, Map<Long, Integer>> idErrorCount) {
        this.idErrorCount = idErrorCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardTaskContext)) {
            return false;
        }
        CardTaskContext other = (CardTaskContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartitionSize() != other.getPartitionSize()) {
            return false;
        }
        if (this.getSingleTaskSize() != other.getSingleTaskSize()) {
            return false;
        }
        if (this.getBatchTaskSize() != other.getBatchTaskSize()) {
            return false;
        }
        if (this.getMaxErrorSize() != other.getMaxErrorSize()) {
            return false;
        }
        List<CardDataParam> this$singleTasks = this.getSingleTasks();
        List<CardDataParam> other$singleTasks = other.getSingleTasks();
        if (this$singleTasks == null ? other$singleTasks != null : !((Object)this$singleTasks).equals(other$singleTasks)) {
            return false;
        }
        List<CardDataParam> this$batchTasks = this.getBatchTasks();
        List<CardDataParam> other$batchTasks = other.getBatchTasks();
        if (this$batchTasks == null ? other$batchTasks != null : !((Object)this$batchTasks).equals(other$batchTasks)) {
            return false;
        }
        AuthoredUser this$authoredUser = this.getAuthoredUser();
        AuthoredUser other$authoredUser = other.getAuthoredUser();
        if (this$authoredUser == null ? other$authoredUser != null : !this$authoredUser.equals(other$authoredUser)) {
            return false;
        }
        Map<String, Map<Long, Integer>> this$idErrorCount = this.getIdErrorCount();
        Map<String, Map<Long, Integer>> other$idErrorCount = other.getIdErrorCount();
        return !(this$idErrorCount == null ? other$idErrorCount != null : !((Object)this$idErrorCount).equals(other$idErrorCount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CardTaskContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartitionSize();
        result = result * 59 + this.getSingleTaskSize();
        result = result * 59 + this.getBatchTaskSize();
        result = result * 59 + this.getMaxErrorSize();
        List<CardDataParam> $singleTasks = this.getSingleTasks();
        result = result * 59 + ($singleTasks == null ? 43 : ((Object)$singleTasks).hashCode());
        List<CardDataParam> $batchTasks = this.getBatchTasks();
        result = result * 59 + ($batchTasks == null ? 43 : ((Object)$batchTasks).hashCode());
        AuthoredUser $authoredUser = this.getAuthoredUser();
        result = result * 59 + ($authoredUser == null ? 43 : $authoredUser.hashCode());
        Map<String, Map<Long, Integer>> $idErrorCount = this.getIdErrorCount();
        result = result * 59 + ($idErrorCount == null ? 43 : ((Object)$idErrorCount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CardTaskContext(singleTasks=" + this.getSingleTasks() + ", batchTasks=" + this.getBatchTasks() + ", authoredUser=" + this.getAuthoredUser() + ", partitionSize=" + this.getPartitionSize() + ", singleTaskSize=" + this.getSingleTaskSize() + ", batchTaskSize=" + this.getBatchTaskSize() + ", maxErrorSize=" + this.getMaxErrorSize() + ", idErrorCount=" + this.getIdErrorCount() + ")";
    }
}

