/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.dto.migration.atmc.ptm;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmBacklogItemBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PtmBacklogTransformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtmBacklogTransformService.class);
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    private boolean enablePTM() {
        return StringUtils.isNotBlank((String)this.envProperties.getPtmUri());
    }

    public List<Map> selectNoFinishedListByOriginBacklogIdForSolve(Long backlogId) {
        ArrayList<Map> result = new ArrayList<Map>();
        if (!this.enablePTM()) {
            return result;
        }
        ArrayList<Long> originalBacklogIds = new ArrayList<Long>();
        originalBacklogIds.add(backlogId);
        PtmBacklog ptmBacklog = this.commonPtmTransformService.getBacklogForCard(backlogId);
        if (ptmBacklog == null) {
            return result;
        }
        List<PtmBacklogItemBO> backlogItemList = this.ptmService.getBacklogByBacklogId(ptmBacklog.getBacklogId());
        backlogItemList.forEach(x -> originalBacklogIds.add(x.getWorkItemId()));
        List<Map> list = this.ptmService.getSolveTaskList(originalBacklogIds);
        log.info("getSolveTask list:{}", (Object)JsonUtils.objectToString(list));
        if (CollectionUtils.isNotEmpty(list)) {
            for (Map x2 : list) {
                if (!x2.containsKey("state") || MapUtils.getInteger((Map)x2, (Object)"state", (Integer)0) == 3) continue;
                x2.put("tm_task_id", x2.get("projectDefCode"));
                x2.put("tm_activity_id", x2.get("taskDefCode"));
                x2.put("dataFrom", "PTM");
                result.add(x2);
            }
        }
        return result;
    }

    public PtmBacklog getReplyOriginalBacklog(Long backlogId) {
        List list;
        PtmBacklog originaalBacklog = null;
        PtmBacklog backlog = (PtmBacklog)this.ptmBacklogMapper.selectById((Serializable)backlogId);
        if (backlog != null && CollectionUtils.isNotEmpty((Collection)(list = this.ptmBacklogMapper.selectByWorkItemId(backlog.getWorkItemId())))) {
            for (PtmBacklog bl : list) {
                if (!Objects.equals(bl.getType(), 0)) continue;
                originaalBacklog = bl;
                break;
            }
        }
        return originaalBacklog;
    }
}

