/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.abt.application.dto.migration.atmc.share.dao;

import com.digiwin.athena.abt.application.dto.migration.atmc.share.dao.ShareCodeDao;
import com.digiwin.athena.abt.application.dto.migration.atmc.share.entity.ShareCodeMongoEntity;
import com.digiwin.athena.abt.application.utils.RandomUtil;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ShareCodeDaoImpl
implements ShareCodeDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShareCodeDaoImpl.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    @Qualifier(value="atmcTempDataMongo")
    private MongoTemplate atmcTempDataMongo;
    public static final String COLLECTIONNAME_SHARECODE = "atmc_share_code";

    @Override
    public String addShareCodeCache(String shareContent, long sharingCodeTtl, TimeUnit sharingCodeTtlTimeUnit) {
        ShareCodeMongoEntity newShare = null;
        int retryTimes = 3;
        boolean needRetry = true;
        while (needRetry && retryTimes-- > 0) {
            try {
                newShare = this.createShareCodeCache(shareContent, sharingCodeTtl, sharingCodeTtlTimeUnit);
                needRetry = false;
            }
            catch (DuplicateKeyException e2) {
                log.warn("\u521b\u5efa\u5206\u4eab\u7801\u4e3b\u952e\u51b2\u7a81\uff0c\u91cd\u8bd5[{}]", (Object)retryTimes);
            }
        }
        return Objects.isNull(newShare) ? "" : newShare.getShareCode();
    }

    private ShareCodeMongoEntity createShareCodeCache(String shareContent, long sharingCodeTtl, TimeUnit sharingCodeTtlTimeUnit) {
        String sharingCode = RandomUtil.genRandomStr(15);
        return this.insertShareCodeCache(sharingCode, shareContent, sharingCodeTtl, sharingCodeTtlTimeUnit);
    }

    private ShareCodeMongoEntity insertShareCodeCache(String sharingCode, String shareContent, long sharingCodeTtl, TimeUnit sharingCodeTtlTimeUnit) {
        Date createTime = new Date();
        ShareCodeMongoEntity shareCodeMongoEntity = ShareCodeMongoEntity.builder().shareCode(sharingCode).shareContent(shareContent).createTime(createTime).expireTime(DateUtils.addSeconds((Date)createTime, (int)((int)sharingCodeTtlTimeUnit.toSeconds(sharingCodeTtl)))).build();
        return (ShareCodeMongoEntity)this.atmcTempDataMongo.insert((Object)shareCodeMongoEntity, COLLECTIONNAME_SHARECODE);
    }

    @Override
    public String getShareCodeCache(String sharingCode) {
        String cachedStr = "";
        Criteria cater = new Criteria();
        Query query = Query.query((CriteriaDefinition)cater);
        cater.and("shareCode").is((Object)sharingCode);
        ShareCodeMongoEntity cachedShareCodeMongoObj = (ShareCodeMongoEntity)this.atmcTempDataMongo.findOne(query, ShareCodeMongoEntity.class, COLLECTIONNAME_SHARECODE);
        if (Objects.nonNull(cachedShareCodeMongoObj)) {
            cachedStr = cachedShareCodeMongoObj.getShareContent();
        }
        return cachedStr;
    }
}

